#include <stdio.h>
#include <string.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "lexpr.h"
#include "input.h"
#include "errors.h"

extern HASHREC **publichash;
extern char *prm_specify;

long evalLinkerExpr(LEXPRESSION *e, long pc, BOOL absexpression)
{
	long value;
	switch(e->type) {
		case EXP_EXTERN: {
			PUBLIC **p = LookupHash(publichash,e->name);
			if (absexpression)
				Error("Expected absolute value");
			if (!p) {
				Error("Unknown Symbol %s in %s", e->name, prm_specify);
				value = 0;
			}
			else {
				if ((*p)->sect)
					value = (*p)->offset + (*p)->sect->base + (*p)->sect->parent->absbase;
				else
					value = (*p)->offset;
			}
			}
			break;
		case EXP_PC:
			if (absexpression)
				Error("Expected absolute value");
			value = pc;
			break;
		case EXP_NUMBER:
			value = e->value;
			break;
		case EXP_PLUS:
			value = evalLinkerExpr(e->left,pc,absexpression) + evalLinkerExpr(e->right,pc,absexpression);
			break;;
		case EXP_MINUS:
			value = evalLinkerExpr(e->left,pc,absexpression) - evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_TIMES:
			value = evalLinkerExpr(e->left,pc,absexpression) * evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_DIVIDE:
			value = evalLinkerExpr(e->left,pc,absexpression) / evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_NEG:
			value = - evalLinkerExpr(e->left,pc,absexpression);
			break;
		case EXP_MOD:
			value = evalLinkerExpr(e->left,pc,absexpression) %  evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_SHL:
			value = evalLinkerExpr(e->left,pc,absexpression) <<  evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_SHR:
			value = evalLinkerExpr(e->left,pc,absexpression) >>  evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_AND:
			value = evalLinkerExpr(e->left,pc,absexpression) &  evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_OR:
			value = evalLinkerExpr(e->left,pc,absexpression) |  evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_XOR:
			value = evalLinkerExpr(e->left,pc,absexpression) ^  evalLinkerExpr(e->right,pc,absexpression);
			break;
		case EXP_NOT:
			value = ~ evalLinkerExpr(e->left,pc,absexpression);
			break;
		case EXP_PAREN:
			value = evalLinkerExpr(e->left,pc,absexpression);
			break;
	}
	if (e->name)
		DeallocateMemory(e->name);
	DeallocateMemory(e);
	return(value);
}
LEXPRESSION *AddLinkerExpression(char *name, int func, long value, LEXPRESSION *left, LEXPRESSION *right)
{
	LEXPRESSION *e = AllocateMemory(sizeof(LEXPRESSION));
	if (name) {
		e->name = AllocateMemory(strlen(name) + 1);
		strcpy(e->name, name);
	}
	else
		e->name = 0;
	e->type = func;
	e->value = value;
	e->left = left;
	e->right = right;
	return(e);
}
LEXPRESSION *AddLinkerAttribs(int type, LEXPRESSION *value, LEXPRESSION *chain)
{
  LEXPRESSION *e = AllocateMemory(sizeof(LEXPRESSION));
	e->name = 0;
	e->type = type;
	e->value = evalLinkerExpr(value,0,TRUE);
	e->left = chain;
	e->right = 0;
	return(e);
}	
LEXPRESSION *MergeLinkerAttribs(LEXPRESSION *top, LEXPRESSION *bottom)
{
	LEXPRESSION *p = top;
	if (p) {
		while (p->left)
			p = p->left;
		p->left = bottom;
		return(top);
	}
	return(bottom);
}
void AssignLinkerPublic(char *name, long value)
{
	if (!LookupHash(publichash, name)) {
		PUBLIC *p = AllocateMemory(sizeof(PUBLIC));
		p->link = 0;
		p->name = AllocateMemory(strlen(name)+1);
		strcpy(p->name, name);
		p->sect = 0;
		p->referenced = FALSE;
		p->id = 0;
		p->modname = 0;
		p->offset = value;
		AddHash(publichash, p);
	}
	else 
		Error("Attempt to reassign symbol %s in %s",name, prm_specify);
}