#include <stdio.h>   
#include <ctype.h>
#include <stdarg.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "public.h"
#include "lexpr.h"
#include "partit.h"
#include "link_tab.h"
#include "input.h"
#include "interp.h"

#define INCLUDELEVELS 2
#define BUFLEN 256

extern BOOL phiused;

char buf[BUFLEN] = "";
char *bufptr = buf;
int level = -1;
int lineno[INCLUDELEVELS];
FILE* ifile[INCLUDELEVELS];
char *filenames[INCLUDELEVELS];
int serrcount = 0;
BOOL newline = FALSE;

void openFile(char *string, char *mode)
{
	if (level == INCLUDELEVELS)
		fatal("Too many levels of include files\n");
	level++;
	lineno[level] = 0;
	filenames[level]= AllocateMemory(strlen(string)+1);
  strcpy(filenames[level],string);
	if (!(ifile[level] = fopen(string, mode))) {
		fatal("Can't open %s\n",string);
	}
  newline = TRUE;
}
void closeFile(void)
{
	fclose(ifile[level]);
	DeallocateMemory(filenames[level]);
	level--;
}
BOOL nextLine(char *buf, int len)
{
	while (!feof(ifile[level])) {
		lineno[level]++;
		if (!philine(buf,len,ifile[level]))
			return(FALSE);
		if (buf[0] != 0) {
			return(TRUE);
		}
	}
	return(FALSE);
}
int skipSpace(char **buf)
{
	int curchar;
	while (iswhitespacechar(curchar = parsechar(buf))) ;
	return(curchar);
}
void yyerror(char *msg)
{
	SpecError(msg);
}
void SpecError(char *fmt,...)
{
  va_list argptr;

  va_start( argptr, fmt);
  printf("Error: ");
 	printf("%s(%d): ",filenames[level],lineno[level]);	
  vprintf( fmt, argptr);
  va_end(argptr);
  putc('\n',stdout);
  serrcount++;
}
int yylex(void)
{
	char buffer[BUFLEN];
	char buf1[BUFLEN];
	BOOL wading = FALSE;
	int curchar;
lex:
	curchar = parsechar(&bufptr);
	if (curchar == 0 || newline) {
		newline = FALSE;
		while (!nextLine( buf, BUFLEN)) {
			closeFile();
			if (level < 0) {
				level = -1;
				return(EOF);
			}
		}
		bufptr = buf;
		curchar =parsechar(&bufptr);
	}
	if (iswhitespacechar(curchar))
		curchar = skipSpace(&bufptr);
	if (wading) {
		while (curchar != '\n') {
			if (curchar == '*') {
				curchar = parsechar(&bufptr);
				if (curchar == '/') {
					curchar = parsechar(&bufptr);
					wading = FALSE;
					break;
				}
			}
			else
				curchar = parsechar(&bufptr);
		}
		if (wading)
			goto lex;
	}
	if (curchar == '\n') {
		newline = TRUE;
		goto lex;
	}
	if (curchar == '/') {
		curchar = parsechar(&bufptr);
		if (curchar == '*') {
			wading = TRUE;
			goto lex;
		}
		bufptr--;
		putphiback(curchar);
		curchar = '/';
	}
	if (iscommentchar(curchar)) {
		do {
			curchar = parsechar(&bufptr);
		} while (curchar != 0x0a && !iscommentchar(curchar));
		if (curchar == 0x0a)
			newline = TRUE;
		goto lex;
	}		
	if (curchar == '$') {
ishex:
		curchar = parsechar(&bufptr);
		if (!isxdigit(curchar)) {
			bufptr--;
			putphiback(curchar);
			return('$');
		}
		yylval.value = 0;
		while(isxdigit(curchar)) {
			char temp = toupper(curchar);
			yylval.value*=16;
			if (temp >= 'A')
				temp-= 7;
			temp -= '0';
			yylval.value+=temp;
			curchar = parsechar(&bufptr);
		}
		putphiback(curchar);
		bufptr--;
		return(NUMBER);
	}
	if (curchar == '%' || (phiused && curchar == SYM_CENT)) {
		int val = curchar;
		curchar = parsechar(&bufptr);
		if (curchar != '0' && curchar != '1') {
			putphiback(curchar);
			bufptr--;
			return(val);
		}
		yylval.value = 0;
		while(curchar == '0' || curchar == '1') {
			char temp = curchar;
			yylval.value*=2;
			if (temp >= 'A')
				temp-= 7;
			temp -= '0';
			yylval.value+=temp;
			curchar = parsechar(&bufptr);
		}
		putphiback(curchar);
		bufptr--;
		return(NUMBER);
	}
	if ((phiused && curchar == SYM_YEN)) {
		int val = curchar;
		curchar = parsechar(&bufptr);
		if (curchar < '0' || curchar > '7') {
			putphiback(curchar);
			bufptr--;
			return(val);
		}
		yylval.value = 0;
		while(curchar >= '0' && curchar <= '7') {
			char temp = curchar;
			yylval.value*=2;
			if (temp >= 'A')
				temp-= 7;
			temp -= '0';
			yylval.value+=temp;
			curchar = parsechar(&bufptr);
		}
		putphiback(curchar);
		bufptr--;
		return(NUMBER);
	}
	if (isdigit (curchar) || (phiused && (curchar == SYM_LB))) {
		if (curchar == SYM_LB)
			curchar = parsechar(&bufptr);
		else
			if (curchar == '0') {
				curchar = parsechar(&bufptr);
				if (curchar == 'x' || curchar == 'X')
					goto ishex;
			}
		yylval.value = 0;
		while(isdigit(curchar)) {
			char temp = curchar;
			yylval.value*=10;
			temp -= '0';
			yylval.value+=temp;
			curchar = parsechar(&bufptr);
		}
		putphiback(curchar);
		bufptr--;
		return(NUMBER);
	}
	if (isstartchar(curchar)) {
		int i = 0;
		installphichar(curchar,buffer,i);
		i+= installphichar(phiupper(curchar),buf1,i);
		curchar = parsechar(&bufptr);
		while(issymchar(curchar) && curchar != '.') {
			installphichar(curchar,buffer,i);
			i += installphichar(phiupper(curchar),buf1,i);
			curchar = parsechar(&bufptr);
		}
		bufptr--;
		putphiback(curchar);
		buffer[i] = 0;
		buf1[i] = 0;
		if ((buffer[i-1] & 0xf0) == 0x90)
			buffer[i-1] = 0x90;
		if (!strcmp(buf1,"REGION"))
			return(REGION);
		if (!strcmp(buf1,"OVERLAY"))
			return(OVERLAY);
		if (!strcmp(buf1,"VIRTUAL"))
			return VIRTUAL;
		if (!strcmp(buf1,"PARTITION"))
			return(PARTITION);
		if (!strcmp(buf1,"ADDR"))
			return(ADDRESS);
		if (!strcmp(buf1,"ALIGN"))
			return(ALIGN);
		if (!strcmp(buf1,"SIZE"))
			return(SIZE);
		if (!strcmp(buf1,"NUMBER"))
			return(NUMBER);
		if (!strcmp(buf1,"ROUNDSIZE"))
			return(ROUNDSIZE);
		yylval.name = AllocateMemory(strlen(buffer)+1);
		strcpy(yylval.name,buffer);
		return(SYMBOL);
	}
	if (phiused && curchar == SYM_SHL)
		return(SHLEFT);
	if (phiused && curchar == SYM_SHR)
		return(SHRIGHT);
	if (curchar == '<') {
		curchar = parsechar(&bufptr);
		if (curchar == '<')
			return(SHLEFT);
		putphiback(curchar);
		bufptr--;
		return('<');
	}
	if (curchar == '>') {
		curchar = parsechar(&bufptr);
		if (curchar == '>')
			return(SHRIGHT);
		putphiback(curchar);
		bufptr--;
		return('>');
	}
	return(curchar);
}