#innclude <time.h>
#include "utype.h"
#include "coff.h"
#include "umem.h"
extern int prm_debug;

static S_FILEHDR filhead;
static S_AOUTHDR aouthead;
static int numsections;
static S_SCNHDR *sectionheads;

void coff_header(long symbase,long syms, short lineno)
{
	filhead.f_magic = COP8MAGIC;
	filhead.f_nscns = numsections;
	filhead.f_timdat = time(0);
	filhead.f_symptr = symbase;
	filhead.f_nsyms = syms;
	filhead.f_opthead = sizeof(S_AOUTHDR);
	filhead.f_flags = F_RELFLG | F_EXEC | F_AR32WR | (lineno ? 0 : F_LINENO );
}
void aout_header(void)
{
	memset(aouthead,0,sizeof(S_AOUTHDR));
}
void section_headers(void)
{
	numsections = 0;
	if (!partitions) {
	  LIST *q = sectionlist;
		while (q) {   	
			numsections++;
			q = q->link;
		}
	}
	else {
		LDESCRIPTION *p = partitions;
		int i = 0;
		while (p) {
			if (p->type == TY_PARTITION) {
				LDESCRIPTION *o = p->downlink;
				while (o) {
					if (o->type == TY_OVERLAY) {
						long size = o->size, address = o->address;
						if (o->address == 0) {
							LDESCRIPTION *r = o->downlink;
							while (r) {
								if (r->type == TY_REGION) {
									address += r->address;
									size -= r->address;
									break;
								}
								r = r->sidelink;
							}
						}
#ifdef LINKASCII
						putascii(file,"ST%X,A,C,N,",i);
						putascii(file,"%02X%s.\r\n",strlen(o->name), o->name);
						putascii(file,"ASS%X,%lX.\r\n",i, size);
						putascii(file,"ASL%X,%lX.\r\n",i, address);
#endif LINKASCII
						i++;
					}
					o = o->sidelink;
				}
			}
			p = p->sidelink;
		}
	}
	putcs(file, FALSE);
	
}