#define MAX_NAMESIZE 32

#define SCAN 1
#define RESOLVE 2

/* Values returned by the record load function */
#define MODERR -1	/* Error this record */
#define MODQUIT -2	/* Never encountered */
#define MODIGNORE -3	/* Record was ignored */

/* Flags for the execution list */
#define TE_REPORT 1	/* Report what record was encountered */
#define TE_IGNORE 2	/* Ignore the record */
#define TE_ERROR  4	/* Generate an error for the record */

/* OMF record handling functions will have this format */
typedef void (*EXECFUNC)(void);

/* Descriptor for an OMF record type */
typedef struct _typexec_ {
	char	select[2];	/* OMF record ID */
	ushort  flags;	/* FLAGS, as above */
	EXECFUNC	run;	/* Routine to run to parse the record */
} TYPEXEC;

#define MAX_OBJECT_SIZE 64000L
#define NAMEMAX 32

typedef struct _modlist_ {
	struct _modlist_ *link;
	char *name;
	EMSMEM *data;
	long len;
	long offset;
} MODULE;

typedef struct _public_ {
	struct _public_ *link;
	char *name;
	MODULE *mod;
} PUBLIC;


#include "module.p"