#include <ctype.h>
#define YES 1
#define NO 0

#define NSYMS	253
#define INCLSTACK	10
#define MAXBYTPERINS	3
#define BYTPERLONG	4
#define LONGLEN	32
#define MAXOPDS	2
#define NHEAD	5	/* words of overhead in binary header */
#define BINBUFLEN	250

#define iswhite(c)	((c)==' ' || (c)=='\t')
#define iseol(c)	((c)=='\0' || (c)==';' || (c)=='\n')
#define isdelim(c)	((c)==',' || (c)==':' || iseol(c) || iswhite(c))
#define islabel(c)	(isalnum(c) || (c)=='_')

#define A_MAX		6	/* highest error code causing immediate abort */
#define E_PASS1		1
#define E_PASS2		2
#define E_STOFLO	3
#define E_INPUT		4
#define E_INCL		5
#define E_INCLSYN	6
#define E_EXPR		7
#define E_UNDEF		8
#define E_ILLOP		9
#define E_MULT		10
#define E_NOPS		11
#define E_TOOBIG	12
#define E_NEG		13
#define E_SEG		14

#define NOOP -1
#define PLUS 0
#define MINUS 1
#define MULT 2
#define DIV 3
#define MOD 4
#define OR 5
#define AND 6
#define EXOR 7
#define SHLF 8
#define SHRT 9
#define OPSTRING "+-*/%|&^<>"   /* same order as definitions above */

#ifdef	MSDOS
	/* Remember that 8086 is a 16-bit engine */
typedef unsigned char Word;	/* instruction word */
typedef int Long;		/* Long, that is, on an 8085: 16 bit data */
typedef char Short;		/* 8 bit data */
typedef unsigned int Memad;
typedef char Flag;
#else
typedef unsigned char Word;     /* instruction word */
typedef short Long;             /* Long, that is, on an 8085: 16 bit data */
typedef char  Short;            /* 8 bit data */
typedef unsigned Long Memad;
typedef char Flag;
#endif

typedef struct opdclassitem {   /* This defines an instruction field */
	int length;                     /* length in bits of field */
	Flag sign;			/* else unsigned */
	Flag byteswapped;               /* data has bytes backwards */
	Flag relative;                  /* field is relative to $ */
	int offset;                     /* fixed value added to field */
} opdclass;

typedef struct insclassitem {   /* This defines an instruction type */
	int length;                     /* instruction length in bytes */
	int mopds;                      /* number of operands expected */
	opdclass *type[MAXOPDS];        /* each operand's field type */
	int offset[MAXOPDS];            /* each operand's bit offset,
					   from right end of first byte */
} insclass;

typedef struct chcitem {        /* Defines the alternatives for instr choices */
	char *rname;                    /* restrictive mnemonic */
	char *nname;                    /* non-restrictive mnemonic */
	int field;                      /* operand that is restricted */
	int lorange, hirange;           /* range of restriction inclusive */
	Flag relative;                  /* to current lc, else absolute value */
} choicedef;

typedef struct opdefitem {      /* Defines an instruction */
	char *name;                     /* instruction mnemonic */
	insclass *class;                /* instruction type */
	Word mask;                      /* mask for first byte of instruction */
	int (*action) ();               /* action routine for assembly */
} opdef;

typedef struct seg {            /* Defines a location counter segment */
	Memad lc, start;                /* segment's lc and starting loc */
	char *name;                     /* segment name */
	struct seg *next;               /* pointer to next segment */
} segmnt;

typedef struct ltitem {         /* Defines a label table entry */
	char *name;                     /* symbol name */
	long value;                     /* symbol's current value */
	opdclass *type;                 /* symbol type (defines fields it can fill) */
	segmnt *segp;                   /* pointer to segment value's defined in */
} symbol;

extern char *malloc();
extern char *strcpy();
extern char *strcat();
extern char *mktemp();
extern char *index();
extern char *fgets();
extern int geninstr();
extern int choiceinstr();
extern int do_bss();
extern int do_data();
extern int do_data2();
extern int do_end();
extern int do_equ();
extern int do_seg();
extern int do_set();
extern int do_org();
extern int do_string();
extern int do_incl();
extern int do_loff();
extern int do_lon();
extern void getargs ();
extern void init ();
extern void init2 ();
extern int process ();
extern void listit ();
extern void insert ();
extern void reporterr ();
extern int hash ();
extern long expr ();
extern int getop ();
extern long getval ();
extern int lookup ();
extern void putoutbin ();
extern void crossref ();
extern void sort ();
extern void putout ();
extern int xtod ();
extern char escape ();

#ifdef	MSDOS
#define	rewind(file)	fseek(file,0L,0)
#endif
