title		w
page		,80

stack		segment 	para stack 'STACK'
		db		256 dup(0)
stack		ends

data		segment 	para public 'DATA'
vect1		dw		0
vect2		dw		0
curatt		db		7,7
escon		db		0,0		; esc key pressed
esc2on		db		0,0		; in graph mode
iobuffer	equ		3f8h
divlatch	equ		3f8h
intenabl	equ		3f9h
intident	equ		3fah
linecont	equ		3fbh
modmcont	equ		3fch
linestat	equ		3fdh
modmstat	equ		3f3h
prtrdata	dw		0
prtrcntl	dw		0
prtrstat	dw		0
prtron		db		0,0
monmode		db		0,0
inbuf		db		4096 dup (?)	; input buffer
ptr1		dw		0
ptr2		dw		0
bufcount	dw		0
busy_flag	dw		0
protocol	dw		0
busy_stat	db		00001011b	; dtr,cts raised
busy_hi 	dw		1800,1800
busy_lo 	dw		100,100
crsr_type	dw		2
ncols		dw		79		; number of columns
dvltch		dw		0ch		; divisor latch 9600
crsr_base	dw		0b000h		; default mono
parm		db		128 dup (0)	; command line buffer
keybuf		db		20
		db		60 dup (?)	; keyboard input buffer
fcb		db		36 dup (0)	; file control block
dta		db		0		; transfer area
fcbp		db		3		; init file drive c
fcbp_n		db		'W       INI'	; w.ini is its name
fcbp_x		db		24 dup (0)	; dos usage    
dtap		dw		0
errmsg		db		'Cannot Access                                '
prompt		db		'Filename:                                    '
space		db		'                                             '
data		ends

code		segment 	para public 'CODE'

prog		proc		far
		assume		cs:code
		push ds
		mov ax,0
		push ax 	; save on stack for return to dos
		mov ax,data	; establish addressability
		mov ds,ax	; that's it
		assume	ds:data

	; poll for printers on system

		mov dx,3bdh	; monochrome adaptor
		in al, dx	; read status
		cmp al,0ffh	; anything there ?
		jz plp0		; not this one
		mov bx,3bch	; yes, set it up
       		jmp polldn	; save
plp0:		mov dx,279h	; at 2nd port
		in al, dx	; read it
		cmp al,0ffh	; there ?
		jz plp1		; no
		mov bx,278h	; set up
		jmp polldn	; save
plp1:		mov dx,379h	; at 1st printer
		in al, dx	; read
		cmp al,0ffh	; better be
      		jz nolpt	; no printer
		mov bx,378h	; our base address
polldn:		mov prtrdata,bx	; save 
		inc bx		; next
		mov prtrstat,bx	; save
		inc bx		; to cntl
		mov prtrcntl,bx	; save
nolpt:


		call get_open_p	; read the init file

	; get original interrupt vectors and save them
		mov ax,0	; page 0 memory
		mov es,ax	; save it
		mov si,30h	; our table
		cld		; fwd pointer
		lodsw		; get vector 1
		mov bx,ax	; copy
		lodsw		; next vector
		push ax 	; save high
		push bx 	; and low

	; divisor latch controls
	; 1200 60h (96)
	; 2400 30h (48)
	; 4800 18h (24)
	; 9600 0ch (12)

	; program the baud rate
		mov dx,linecont ; line control register
		mov al,10000111b; to address dlab
		out dx,al	; now its addressable
		lea di,dvltch	; point divisor
		mov al,[di]	; get it
		mov dx,divlatch ; lsb
		out dx,al	; program it
		inc dx		; to msb address
		mov al,0	; divisor msb
		out dx,al	; end baud

	 ; program divisor latch off, 8 bits no parity
		mov dx,linecont ; back to line control register
		mov al,00000111b; 8 bits no parity, dlab off
		out dx,al	; program it

	; allow interrupts on the modem line and make unbusy
		mov al,00001011b
		mov dx,modmcont ; ints on
		out dx,al	; unbusy

	; now get our interrupt service routine into
	; the vector table
		mov ax,0	; clear a register
		mov es,ax	; copy to extra segment
		mov di,30h	; offset of entry for 0ch ints

		mov ax,offset intserv

		cld
		stosw
		mov ax,cs
		stosw

	; now for the interrupt mask register of the 8259
		mov dx,21h			; 8259 controller
		in al,dx			; get current
		and al,11101111b		; ensure this one is on
		mov al,0			; enable all ints
		out dx,al			; do it

	; now define the interrupts  allowed - only rx data ready
		mov al,1
		mov dx,intenabl 		; ints on
		out dx,al			; avail ints
		mov al,00001011b
		mov dx,modmcont 		; ints on
		out dx,al			; unbusy

		sti				; turn them on
		lea di,curatt			; get cursor
		mov al,15			; normal video
		mov [di],al			; park it
		call cursor_large		; big cursor
		call clr_scrn		      	; clear the screen

spin:
		mov dl,0ffh			; for input
		mov ah,6			; fn call
		int 21h 			; check status
		jnz keyin			; got one
		jmp cspin			; no char there
keyin:		or al,al			; special key ?
		jnz normal			; no , normal
		mov dl,0ffh			; for second
		mov ah,6			; fn call
		int 21h 			; get second char
		cmp al,67			; f9=break
		jnz notbreak			; no
		mov dx,linecont			; line control reg
		in al, dx			; get status
		push ax				; save it
		or al, 01000000b		; break bit on
		out dx, al			; send break
		call sleep			; wait
		pop ax				; restore al
		out dx, al			; normal status
		jmp spin			; done
notbreak:	cmp al,66			; f8 = reset
		jnz notreset			; no
		lea di,curatt			; set attr
		mov al,00001111b		; normal
		mov [di], al			; set it
		mov al, 0			; no flag
		lea di,monmode			; monitor mode
		mov [di],al			; off
		lea di,prtron			; printthru
		mov [di],al			; off
		lea di,esc2on			; graphics
		mov [di],al			; off
		lea di,escon			; state
		mov [di],al			; reset
		jmp spin			; done
notreset:	cmp al,71			; numeric pad ?
		jb n2				; no
		cmp al,83			; max numeric ?
		ja n2				; no
		add al,89			; offset
		jmp normal			; process
n2:		cmp al,59			; lo fn key
		jb n3				; no
		cmp al,68			; hi fn key
		ja n3				; no
		add al,70			; to offset
		jmp normal			; process it
n3:		cmp al,84			; lo shift fn key
		jb n4				; no
		cmp al,93			; hi shift fn key
		ja n4				; no
		add al,55			; offset
		jmp normal			; process it
n4:		cmp al,104			; lo alt fn key
		jb normal			; nope
		cmp al,113			; hi alt fn key
		ja normal			; nope
		add al,142			; offset
normal:		cmp al,254			; file xport?
		jz xprt 			; yes
		jmp nfx 			; no
xprt:		mov dl,0			; col 0
		mov dh,24			; row 25
		call prat			; print at it
		mov cx,10			; chars to print
		mov bx,offset prompt		; our fn prompt
		call mssg			; display it
		mov dl,12			; col
		mov dh,24			; row
		call prat			; mov cursor
		mov ax,data			; to be sure
		mov ds,ax			; copy
		mov dx,offset keybuf		; our input buffer
		mov ah,0ah			; to input a line
		int 21h 			; get the line
		mov dl,0			; col 0
		mov dh,24			; row 25
		call prat
		mov cx,30			; chars to do
		mov bx,offset space		; blank out 30 chars
		call mssg			; do it
		mov dl,0
		mov dh,24
		call prat			; back to 1st col
		call parse_fn			; parse the filename
		mov ax,data			; our data area
		mov es,ax			; copy
		mov ds,ax			; copy
		assume es:data			; to address it
		assume ds:data			; to address it
		mov dx,offset dta		; address of dta
		mov ah,1ah			; fn set dta
		int 21h 			; set it
		mov dx,offset fcb		; fcb address
		mov ah,0fh			; fn open file
		int 21h 			; open it
		cmp al,0			; did we open it ?
		jz itsopen			; yes
ohoh:		mov cx,20
		mov bx,offset errmsg		; our message
		call mssg			; display it
		mov al,7			; carry on
		jmp n13 			; ring bell
itsopen:	mov word ptr fcb+0ch,0		; current block
		mov word ptr fcb+0eh,1		; record size
		mov fcb+20h,0			; current record
filein: 	mov dx,offset fcb		; fcb address
		mov ah,14h			; seq read
		int 21h 			; invoke function
		cmp al,0			; error ?
		jnz ohoh			; yes
		mov al,dta			; get char just read
		cmp al,1ah			; eof ?
		jz eof				; yup
		cmp al,0ah			; line feed ?
		jz filein			; yes, ignore
		call put_com			; ship the character
		jmp filein			; for next
eof:		mov dx,offset fcb		; our file
		mov ah,10h			; close it
		int 21h 			; do it
		jmp cspin			; all done
nfx:		cmp al,255			; alt f-10 ?
		jnz normal1			; no

		call cursor_small		; restore cursor
		mov al,' '                      ; a space
		call put_char			; do it

		pop ax
		pop ax
		ret



normal1:
		call ship			; out the modem

cspin:		call in_stat			; check mdm status
		or al,al			; any char ?
		jnz getit			; yes, input it
		jmp spin			; no, check keybd
getit:
		call in_get			; grab from buffer
monon:		push ax				; save
		lea di,monmode			; are we in monitor mode ?
		mov al,[di]			; check
		cmp al,3			; if 3 we are
		jnz monoff			; no
		pop ax				; restore char in al
		cmp al,27			; esc ?
		jnz monpc
		push ax
		lea di,escon
		mov al,3
		mov [di],al			; set esc flag
		pop ax				; restore
monpc:		cmp al,'X'			; mon off ?
		jnz nmonpc			; no
		push ax				; save
		lea di, escon			; check esc flag
		mov al,[di]			; retrieve
		cmp al,3			; was it on ?
		jnz mpc0			; no
		mov al,0			; reset
		lea di,escon			; reset esc
		mov [di],al			; off
		lea di,monmode			; and mon
		mov [di],al			; off
mpc0:		pop ax				; restore regs		
nmonpc:		call put_char			; disp as is
		jmp cspin

monoff:		lea di, prtron
		mov al,[di]
		cmp al,24
		jnz ntprntp
		pop ax
		call printch
		jmp cspin

ntprntp:	pop ax
		cmp al,24
		jnz tranin
		lea di,prtron
		mov [di],al
		jmp cspin
tranin: 	push ax 			; save char
		lea di,escon
		mov al,[di]
		cmp al,3			; issued ?
		jnz escoff			; no
		jmp esc0			; yes
escoff: 	pop ax				; restore char
		cmp al,27			; escape ?
		jnz notesc			; no
		mov al,3			; esc flag
		lea di,escon
		mov [di],al			; save it
		jmp tdone			; done
notesc: 	push ax 			; save again
		lea di, esc2on			; 2nd esc
		mov al,[di]			; check it
		cmp al,3			; grafs on ?
		jnz nograf			; no, process
		pop ax				; restore stack
		push ax 			; save again
		cmp al,'0'                      ; is it a graphable char?
		jl nograf			; no
		cmp al,'?'                      ; above graphic range ?
		ja nograf			; no
		pop ax				; clear stack
		call graftrans			; translate it
		call put_char			; display it
		jmp tdone			; done
nograf: 	pop ax				; restore char
		cmp al,10			; lf ?
		jnz n10 			; nope
		call gat			; get current posn
		inc dh				; up row
		call reposn			; reposition
		jmp tdone			; done
n10:		cmp al,13			; cr ?
		jnz n13 			; no
		call gat			; get current posn
		mov dl,0			; col 1
		call reposn			; reposition it
		jmp tdone			; to done
n13:		cmp al,7			; bell ?
		jnz n7				; no
		mov di,900			; freq
		mov bx,2			; duration
		call sound			; beep horn
		mov di,1200			; freq
		mov bx,2			; duration
		call sound			; beep horn
		mov di,1800			; freq
		mov bx,2			; duration
		call sound			; beep horn
		jmp tdone			; done
n7:		cmp al,30			; home cursor ?
		jnz n30 			; nope
		call home			; do it
		jmp tdone		       	; done
n30:		cmp al,8			; backspace ?
		jnz n8				; no
		call gat			; get current cursor
		cmp dl,1			; below col 2 ?
		jl tdone			; yes, ignore
		dec dl				; down 1
		call reposn			; reposition it
		jmp tdone			; done
n8:		cmp al,26			; cursor up ?
		jnz n26 			; no
		call gat			; get current pson
		cmp dh,1			; top line already ?
		jl tdone			; yes, ignore
		dec dh				; one less
		call reposn			; reposition it
		jmp tdone			; done
n26:		cmp al,12			; cursor right ?
		jnz n12 			; no
		call gat			; get posn
		inc dl				; bump col
		call reposn			; reposition it
		jmp tdone			; all done
n12:
do_it:		call put_char			; echo char
tdone:		jmp cspin			; next char

esc0:		; if falls thru to here, second char of
		; escape sequence
		mov al,0			; zero esc flag
		lea di,escon
		mov [di],al			; and replace it
		pop ax				; restore character
		cmp al,'+'                      ; cl scrn ?
		jnz eplus			; no
		call clr_scrn		      	; clear it
		jmp tdone			; done
eplus:		cmp al,')'                      ; pon ?
		jnz n_pon			; no
		lea di,curatt
		mov al,[di]			; retrieve
		and al,11110111b		; reduced intensity
		jmp ngdone			; replace attr

n_pon:		cmp al,'('                      ; poff ?
		jnz n_poff			; no
		lea di,curatt
		mov al,[di]			; retrieve
		or al,00001000b 		; turn on hi intense
		jmp ngdone			; replace

n_poff: 	cmp al,'`'                      ; cursor control ?
		jnz notcurs			; no
		call wait_com			; get next
		cmp al,'3'                      ; small ?
		jnz c_1 			; no
		call cursor_small		; shrink it
		jmp tdone			; done
c_1:		cmp al,'2'                      ; large ?
		jnz c_2 			; no
		call cursor_large		; big cursor
		jmp tdone			; done
c_2:		cmp al,':'			; 80 cols
		jnz c_3				; no
		call cursor_80			; goto 80 x 25
		jmp tdone			; done
c_3:		cmp al,';'			; 132 cols
		jnz c_4				; nope
		call cursor_132			; goto 132 x 25
		jmp tdone			; done
c_4:
		jmp tdone			; done
notcurs:	cmp al,'F'                      ; program user line ?
		jnz escf			; no
		mov dl,0			; col 1
		mov dh,24			; row 25
		call reposn			; point
		jmp tdone			; up we go
escf:		cmp al,'R'                      ; delete row ?
		jnz escr			; no
		lea di, curatt
		mov al,[di]			; get it
		mov bh,al			; load bh with it
		call gat			; my address
		mov ch,dh			; our row
		mov cl,0			; col 0
		mov dh,24			; bot right
		mov dl,79			; to scroll
		mov al,1			; one line only
		mov ah,6			; function number
		int 10h 			; zap the line
		jmp tdone			; leave cursor alone
escr:		cmp al,'E'                      ; ins row ?
		jnz esce			; no, skip it
		lea di, curatt
		mov al,[di]			; get attributes
		mov bh,al			; copy
		call gat			; our position
		mov ch,dh			; top row
		mov cl,0			; col 0
		mov dh,23			; bot row
		mov dl,79			; bot col
		mov al,1			; one row
		mov ah,7			; scroll down
		int 10h 			; do it
		jmp tdone			; all done
esce:		cmp al,'Y'                      ; eos ?
		jnz escte			; no
		call eos			; do it
		jmp tdone			; carry on
escte:		cmp al,'T'                      ; eol ?
		jnz escemo			; no
		call eol			; do the eol
		jmp tdone			; done
escemo:		cmp al,'U'			; monitor mode ?
		jnz escemf			; no
		lea di,monmode			; point flag
		mov al,3			; turn on
		mov [di],al			; save
		jmp tdone			; done
escemf:		cmp al,'X'			; mon off ?
		jnz esceq			; no
		lea di,monmode			; point flag
		mov al,0			; reset
		mov [di],al			; store
		jmp tdone
esceq:		cmp al,'='                      ; address cursor ?
		jnz ndis			; no
		call wait_com			; get next
		sub al,32			; wyse offset
		mov dh,al			; save it
		push dx 			; on stack
		call wait_com			; next
		sub al,32			; wyse offset
		pop dx				; restore other
		mov dl,al			; cpy
		call prat			; reposn
		jmp tdone			; done
ndis:		cmp al,'H'                      ; graf on ?
		jnz ngon			; no
		call wait_com			; get following
		mov ah,0			; zero
		cmp al,3			; off?
		jz  ng2 			; yes, flag it off
		mov ah,3			; set for on
		cmp al,2			; on ?
		jz  ng2 			; yes, flag it on
		call graftrans			; trans char
		call put_char			; display it
		jmp tdone
ng2:		mov al,ah			; copy flag
		lea di,esc2on			; 2nd esc
		mov [di],al			; save it
		jmp tdone			; flag switched
ngon:		cmp al,'G'                      ; attribute ?
		jnz notscrn			; no
		call wait_com			; next
		push ax 			; save
		pop bx				; copy to bx
		lea di,curatt			; point mem
		mov al,[di]			; retrieve
		cmp bl,'0'                      ; normal ?
		jnz ng3 			; nope
		or al,00000111b 		; turn on low
		and al,00001111b		; and off high
		jmp ngdone			; save attribute
ng3:		cmp bl,'4'                      ; rvon ?
		jnz ng4 			; no
		or al,01110000b 		; turn on high
		and al,11111000b		; and off low
		lea di, curatt
		mov [di],al			; save it
		call gat			; get current cursor
		inc dl				; offset one column
		call prat			; put back
		jmp tdone			; done
ng4:		cmp bl,'2'                      ; blink on ?
		jnz ng5 			; nope
		or al,10000000b 		; blink bit on
		jmp ngdone			; put it back
ng5:		cmp bl,'8'                      ; ulon ?
		jnz ngdone			; no, ignore other
		or al,00000001b 		; on ul bit
		and al,10001001b		; leave blnk and prot only
ngdone:		lea di,curatt			; point attr
	 	mov [di],al			; save current attribute
		jmp tdone			; all done
notscrn:
		; future translations here

		jmp tdone			; all done

prog		endp

wait_com	proc				; waits for next com char
		; should have a time-out routine
wcom1:		call in_stat			; char there ?
		or al,al			; test bit 1
		jz wcom1			; spin till there
		call in_get			; receive character
		ret				; done
wait_com	endp

put_com 	proc				; puts al to the comm
		and al,0ffh			; 7 bits only
		push ax 			; save char
		mov dx,linestat 		; check status
pc1:		in al,dx			; get it
		and al,20h			; check tx rg status
		or al,al			; wait till clear
		jz pc1				; spin
		pop ax				; restore character
		mov dx,iobuffer 		; comm 1
		out dx,al			; ship it
		ret				; done
put_com 	endp

ship		proc				; to allow translation
		cmp al,187			; ctrl-ins ?
		jnz ns_0			; nope
		mov al,'E'                      ; translate
		jmp eout			; bye
ns_0:		cmp al,216			; alt-ins
		jnz ns_1			; no
		mov al,'E'                      ; same as above
		jmp eout			; do it
ns_1:		cmp al,188			; ctrl-del
		jnz ns_2			; no
		mov al,'R'                      ; delete line
		jmp eout			; done
ns_2:		cmp al,217			; alt-del
		jnz bt				; no
		mov al,'T'                      ; eol
		jmp eout			; send it
bt:		cmp al,128			; back tab ?
		jnz nbt 			; nope
		mov al,'I'                      ; esc I
		jmp eout			; and out it
nbt:		cmp al,160			; home ?
		jnz s160			; no
		mov al,30			; yes, sub rs
		jmp sout			; and ship it
s160:		cmp al,161			; cursor up ?
		jnz s161			; nope
		mov al,11			; sub
		jmp sout			; do it
s161:		cmp al,162			; page up ?
		jnz s162			; nope
		mov al,'J'                      ; our char
		jmp eout			; escape it out
s162:		cmp al,164			; cursor left ?
		jnz s164			; no
		mov al,8			; baksp
		jmp sout			; out
s164:		cmp al,166			; right ?
		jnz s166			; no
		mov al,12			; repl
		jmp sout			; done
s166:		cmp al,168			; end ?
		jnz s168			; no
		mov al,'7'                      ; repl with send
		jmp eout
s168:		cmp al,169			; cursor down ?
		jnz s169			; nope
		mov al,10			; copy linefeed
		jmp sout
s169:		cmp al,170			; page down ?
		jnz s170			; no
		mov al,'K'                      ; esc -j
		jmp eout
s170:		cmp al,171			; insert ?
		jnz s171
		mov al,'Q'
		jmp eout
s171:		cmp al,172			; delete ?
		jnz s172			; no
		mov al,'W'
		jmp eout
s172:		cmp al,129			; f1 ?
		jnz s129			; no
		mov al,1bh			; escape
		jmp eout			; two escapes
s129:		cmp al,130			; help ?
		jnz s130			; no
		mov al,2			; ctrl b
		jmp sout			; straight out
s130:		cmp al,128			; test for fn key
		jb sout 			; no, ship
		cmp al,148			; shift/f10 ?
		ja sout 			; no, ship
		push ax 			; save it
		mov al,1			; lead in
		call put_com			; send it
		pop ax				; restore
		sub al,65			; make 7 bit ascii
		call put_com			; ship it
		mov al,13			; cr to end
		jmp sout			; done
eout:		push ax 			; save char
		mov al,1bh			; escape
		call put_com			; send it
		pop ax				; restore
sout:		call put_com			; bye
		ret				; done
ship		endp

home		proc				; home cursor
		mov dx,0			; row 0, col 0
		mov ah,2			; set curs
		mov bh,0			; page
		int 10h 			; let rom do it
		ret				; done
home		endp

clr_scrn	proc				; to clear screen
		mov ah,6			; fn
		lea di,ncols			; point no of cols
		mov al,[di]			; get it
		mov dl,al			; copy
		mov al,0			; top left
		mov cx,0			; count
		mov dh,24			; bot row
		mov bh,15			; attribute
		int 10h 			; do it
		mov dx,0			; cursor posn
		mov ah,2			; fn
		mov bh,0			; page
		int 10h 			; set it
		ret				; all done
clr_scrn	endp

gat		proc				; current position
		push ax 			; save
		mov bh,0			; page
		mov ah,3			; read psn
		int 10h 			; do it
		pop ax				; restore
		ret				; with posn in dx
gat		endp

prat		proc				; position at dl,dh x,y
		mov bh,0			; page
		mov ah,2			; pos cursor call
		int 10h 			; do it
		ret				; done
prat		endp

eos		proc				; erase end of screen
		call eol			; eol first
		lea di,curatt
		mov al,[di]			; get it
		mov bh,al			; copy
		call gat			; my address
		mov al,23			; max rows
		sub al,dh			; current row
		jz eos_out			; already at row 24
		mov ch,dh			; current row
		inc ch				; add one
		mov cl,0			; col 0
		mov dh,24			; scroll to bot
		mov dl,79			; right corner
		mov ah,6			; fn request
		int 10h 			; do it
eos_out:	ret				; done
eos		endp

eol		proc				; erase end of line
		mov ah,3			; read posn
		int 10h 			; do it
		push dx 			; save current posn
		mov al,80			; chars to erase
		sub al,dl			; minus current
		mov ch,0			; lsb
		mov cl,al			; msb
		lea di,curatt			; current attribute
		mov bl,[di]			; copy
		mov bh,0			; page
		mov ah,9			; char disp fn
		mov al,' '                      ; char to disp
		int 10h 			; do it
		pop dx				; save old
		mov ah,2			; prat
		int 10h 			; position it
		ret				; end
eol		endp

put_char	proc				; display char on screen
		lea di,curatt			; current attribute
		mov bl,[di]			; copy it
		mov cx,1			; one char to write
		mov ah,9			; fn
		mov bh,0			; page
		int 10h 			; display it
		mov ah,3			; get current posn
		int 10h 			; read it
		inc dl				; bump column
		cmp dl,80
		jl pc0

;		lea di,ncols			; no of cols
;		mov al,[di]			; get it
;		cmp dl,al			; over right ?
;		jle pc0				; no, just reposn
		mov dl,0			; wrap
		inc dh				; next row
pc0:		cmp dh,25			; are we off the screen ?
		jl repos			; no
		dec dh				; down 1
		push dx 			; save it
		mov al,1			; one line to scroll
		mov ah,6			; fn code
		mov cx,0			; top left
		mov dh,24			; bot right
		mov dl,79			; bot right
		lea di,curatt			; current attribute
		mov bh,[di]			; to use for new line
		int 10h 			; scroll up
		pop dx				; restore old posn
repos:		mov bh,0			; page
		mov ah,2			; posn cursor
		int 10h 			; do it
		ret				; done
put_char	endp

reposn		proc				; reposn the cursor
;		lea di,ncols			; get no of cols
;		mov al,[di]			; into al
;		cmp dl,al			; over right ?
;		jle rp0				; no, just reposn
		cmp dl,80
		jl rp0
		mov dl,0			; wrap
		inc dh				; next row
rp0:		cmp dh,25			; are we off the screen ?
		jl rp1				; no
		dec dh				; down 1
		push dx 			; save it
		mov al,1			; one line to scroll
		mov ah,6			; fn code
		mov cx,0			; top left
		mov dh,24			; bot right
		mov dl,79			; bot right
		lea di,curatt			; current attribute
		mov bh,[di]			; to use for new line
		int 10h 			; scroll up
		pop dx				; restore old posn
rp1:		mov bh,0			; page
		mov ah,2			; posn cursor
		int 10h 			; do it
		ret				; done
reposn		endp

sound		proc				; beep the horn
		push ax 			; save everything
		push bx
		push cx
		push dx
		push di
		mov al,086h			; timer mode register
		out 43h,al			; program it
		mov dx,14h			; timer divisor
		mov ax,4f38h			; 1331000 frequency
		div di				; by our duration
		out 42h,al			; low byte
		mov al,ah			; msb
		out 42h,al			; hi byte
		in al,61h			; current portb setting
		mov ah,al			; save it
		or al,3 			; spkr on
		out 61h,al			; do it
swait:		mov cx,2801			; 10 ms
spkr_on:	loop spkr_on			; do the wait
		dec bx				; duration
		jnz swait			; until done
		mov al,ah			; old portb setting
		out 61h,al			; restore it
		pop di				; restore
		pop dx
		pop cx
		pop bx
		pop ax				; all registers used
		ret				; all done
sound		endp

graftrans	proc				; emulate w50 grafix
		cmp al,'0'
		jnz gt1
		mov al,194
		jmp gtr
gt1:		cmp al,'1'
		jnz gt2
		mov al,192
		jmp gtr
gt2:		cmp al,'2'
		jnz gt3
		mov al,218
		jmp gtr
gt3:		cmp al,'3'
		jnz gt4
		mov al,191
		jmp gtr
gt4:		cmp al,'4'
		jnz gt5
		mov al,195
		jmp gtr
gt5:		cmp al,'5'
		jnz gt6
		mov al,217
		jmp gtr
gt6:		cmp al,'6'
		jnz gt7
		mov al,179
		jmp gtr
gt7:		cmp al,'7'
		jnz gt8
		mov al,178
		jmp gtr
gt8:		cmp al,'8'
		jnz gt9
		mov al,197
		jmp gtr
gt9:		cmp al,'9'
		jnz gt10
		mov al,180
		jmp gtr
gt10:		cmp al,':'
		jnz gt11
		mov al,196
		jmp gtr
gt11:		cmp al,';'
		jnz gt12
		mov al,177
		jmp gtr
gt12:		cmp al,'<'
		jnz gt13
		mov al,205
		jmp gtr
gt13:		cmp al,'='
		jnz gt14
		mov al,193
		jmp gtr
gt14:		cmp al,'>'
		jnz gt15
		mov al,186
		jmp gtr
gt15:		cmp al,'?'
		jnz gtr
		mov al,176
gtr:		ret
graftrans	endp

cursor_small	proc
		mov ah,1
		mov ch,11
		mov cl,12
		int 10h
		ret
cursor_small	endp

cursor_large	proc
		mov ah,1
		mov ch,1
		mov cl,12
		int 10h
		ret
cursor_large	endp

cursor_80	proc
		mov al,79
		lea di, ncols
		mov [di], al
		mov ax,3
		int 10h
		ret
cursor_80	endp

cursor_132	proc
		mov al,131
		lea di,ncols
		mov [di], al
		mov ax,53h
		int 10h
		ret
cursor_132	endp

in_stat 	proc
		push bx
		mov ax,data	; establish addressability
		mov ds,ax	; that's it
		mov es,ax	; copy
		cli				; int off
		mov bx,ptr1			; first ptr
		cmp bx,ptr2			; same as input ?
		jnz inst1			; no, make non zero
inst0:		mov al,0			; no characters
		jmp short inst2 		; to return
inst1:		mov al,1			; make non zero
inst2:		sti				; ints back on
		pop bx				; restore
		ret				; done
in_stat 	endp

in_get		proc				; get a char from buffer
		push bx 			; save
		cli				; ints off
		mov bx,bufcount 		; our counter
		dec bx				; one less now
		mov bufcount,bx 		; up to date
		cmp bx,100			; exactly 100 chars ?
		jnz igother			; no
		call unbusy			; make device not busy
igother:	mov bx,ptr1			; out character
		mov al,[inbuf+bx]		; the character
		inc bx				; next char
		cmp bx,4095			; end of buffer ?
		jc ig1				; if not
		mov bx,0			; yes, wrap around
ig1:		mov ptr1,bx			; save new output pointer
		sti				; ints back on
		pop bx				; restore original
		ret				; done
in_get		endp

intserv 	proc   far			; int service routine
		push ax 			; save
		push bx
		push dx
		push di
		mov ax,es			; copy es
		push ax 			; and save
		mov ax,ds			; copy ds
		push ax 			; and save
		mov ax,data			; establish addressability
		mov ds,ax			; that's it
		mov es,ax			; copy
is4:		mov dx,3f8h			; port
		in al,dx			; read it
		mov bx,bufcount 		; count up
		inc bx				; add one
		mov bufcount,bx 		; and save it
		cmp bx,3584			; count high ?
		jnz is4a			; no
		push bx				; save count
		call busy			; device busy
		pop bx				; and restore
is4a:		mov bx,ptr2			; input pointer
		mov [inbuf+bx],al		; park it
		inc bx				; to next char
		cmp bx,4095			; end of buffer ?
		jc is3				; no
		mov bx,0			; yes, wrap around
is3:		cmp bx,ptr1			; full ?
		jz is2				; yes, we lose a char
		mov ptr2,bx			; new eob
is2:		mov dx,20h			; 8259 cmd register
		mov al,20h			; eoi notice
		out dx,al			; mail it to the 8259
		pop ax				; get back ds
		mov ds,ax			; into ds
		pop ax				; get back es
		mov es,ax			; and copy it
		pop di				; back again
		pop dx				; restore used registers
		pop bx				; rest
		pop ax				; rest
		iret				; done
intserv 	endp

mssg		proc				; print a message on screen
mssg1:		mov al,[bx]			; get a char
		call dispchar			; display it
		inc bx				; to next
		loop mssg1			; until done
		ret				; all done
mssg		endp

dispchar	proc				; disp a char in al
		push bx 			; save
		mov bx,0			; page 0
		mov ah,14			; fn for write a char
		int 10h 			; do it
		pop bx				; restore
		ret				; all done
dispchar	endp

parse_fn	proc		near		; parse a filename
		mov ax,data
		mov ds,ax
		mov es,ax			; address registers
		assume ds:data
		assume es:data
		mov di,offset fcb
		inc di
		mov al,' '
		mov cx,12
		cld
		rep stosb			; fill with spaces
		mov si,offset keybuf		; kbd buffer
		inc si
		inc si
		cld
		mov di,offset fcb		; target
		inc di
		mov cx,8			; for fname
pf1:		mov al,es:[si]			; get a byte
		cmp al,0dh			; cr ?
		jz pf7				; yes, all done
		cmp al,'.'                      ; separator ?
		jz pf2				; yes, space out
		cmp al,'a'                      ; lower case ?
		jl pf3				; no
		sub al,32			; fold to upper
pf3:		mov ds:[di],al			 ; copy it
		inc si
		inc di
		dec cx
		jnz pf1 			; count down
		jmp pf4 			; for the extension
pf2:		inc si				; past the period
		cmp cx,0			; name done ?
		jz pf4				; yes
pf2a:		inc di
		dec cx
		jnz pf2a
pf4:		mov cx,3
pf5:		mov al,es:[si]
		cmp al,0dh			; cr ?
		jz pf7				; yes, return
		cmp al,'.'
		jz pf6a
		cmp al,'a'
		jl pf6
		sub al,32
pf6:		mov ds:[di],al
pf6a:		inc si
		inc di
		dec cx
		jnz pf5
pf7:		ret
parse_fn	endp

sleep		proc
		push dx
		push cx
		cli
		mov dx,1200
sl1:		mov cx,550
sl2:		loop sl2
		dec dx
		jnz sl1
		sti
		pop cx
		pop dx
		ret
sleep		endp

printch		proc
		cmp al,20		; end of txp print ?
		jnz printout		; nope
		mov al,0		; clear byte
		lea di,prtron		; place to keep it
		mov [di], al		; park it
		ret
printout:	push ax
		push dx
		push bx
		mov bx,prtrdata
		push bx
		pop dx
		out dx,al
		inc dx			; point to prtrstat
printwt:	in al, dx
		test al,80h
		jz printwt
		inc dx			; point prtrcntl
		mov al,0dh
		out dx, al		; strobe
		mov al,0ch		; clear strobe
		out dx,al		; strobe off
		pop bx
		pop dx
		pop ax
		ret
printch		endp

fgetc		proc			; get a char from the parameter
		mov dx,offset fcbp	; file into dtap
		mov ah,14h
		int 21h
		ret
fgetc		endp

get_open_p	proc
		mov ax,data			; our data area
		mov es,ax			; copy
		mov ds,ax			; copy
		assume es:data			; to address it
		assume ds:data			; to address it
		mov dx,offset dtap		; address of dta
		mov ah,1ah			; fn set dta
		int 21h 			; set it
		mov dx,offset fcbp		; fcb address
		mov ah,0fh			; fn open file
		int 21h 			; open it
		cmp al,0			; did we open it ?
		jz iniopen			; yes
gopdone:	ret				; no, not there
iniopen:	mov word ptr fcbp+0ch,0		; current block
		mov word ptr fcbp+0eh,1		; record size
		mov fcb+20h,0			; current record
pfilein: 	call fgetc			; get a char
		cmp al,0			; error ?
		jnz gopdone			; yes
		lea di, dtap
		mov al,[di]
		cmp al,1ah			; eof ?
		jnz pfeof			; yup
		jmp gopeof
pfeof:		cmp al,0ah			; line feed ?
		jz pfilein			; yes, ignore
		cmp al,'a'			; lower case ?
		jl folded			; no
		sub al,32			; fold low
folded:		cmp al,'B'			; baud rate ?
		jnz nbaud			; nope
weq:		call fgetc			; get to equals sign
		cmp al,0			; error ?
		jnz gopdone
		lea di, dtap
		mov al,[di]
		cmp al,'1'			; 1200 or 19200
		jnz nbaud1		
		call fgetc			; for next
		lea di,dtap
		mov al,[di]
		cmp al,'2'			; 1200 ?
		jnz nbaud0			; nope, 19200
		mov al,60h			; for 1200
putbaud:	lea di,dvltch			; point
		mov [di],al			; save it
		jmp pfilein			; done
nbaud0:		mov al,06h			; 19200
		jmp putbaud
nbaud1:		cmp al,'2'			; 2400 ?
		jnz nbaud2			; no
		mov al,30h			; divisor
		jmp putbaud
nbaud2:		cmp al,'3'			; 38400 ?
		jnz nbaud3			; no
		mov al,03h			; divisor
		jmp putbaud
nbaud3:		cmp al,'4'			; 4800 ?
		jnz nbaud4			; no
		mov al, 18h
		jmp putbaud
nbaud4:		mov al,0ch			; 9600 default
		jmp putbaud			; that's it for bauds
nbaud:		cmp al,'E'			; handshake ?
		jz pproto			; yes
		jmp pfilein			; wait for it
pproto:		call fgetc			; next char
		lea di,dtap
		mov al,[di]
		cmp al,'1'			; dtr ?
		jnz nprot1			; nope
putprot:	lea di, protocol		; point flag
		mov [di],al			; save it
		jmp pfilein			; next char
nprot1:		cmp al,'2'			; xon/xoff ?
		jz putprot			; yes
		cmp al,'4'			; rts/cts ?
		jz putprot			; save it
		jmp pfilein			; other unknown
gopeof:		mov dx,offset fcbp		; our file
		mov ah,10h			; close it
		int 21h 			; do it
		ret				; all done
get_open_p	endp

busy		proc				; make device busy
		push ax				; save registers
		push dx
		mov dx,modmcont
		lea di, protocol
		mov al,[di]			; how ?
		cmp al,'1'			; dtr ?
		jnz nbusy1			; nope
		mov al,busy_stat		; get it
		and al,00001010b		; bit 0 off
		out dx,al			; change line
		mov busy_stat,al		; save status
		jmp busy_done			; done
nbusy1:		cmp al,'2'			; xon/xoff ?
		jnz nbusy2			; no
		mov al,19			; xoff
		call put_com			; send it
		jmp busy_done			; done
nbusy2:		cmp al,'4'			; rts/cts
		jnz busy_pop			; no handshake
		mov al,busy_stat		; get old		
		and al,00001001b		; drop rts
		out dx,al			; program it
		mov busy_stat,al		; save status
busy_done:	mov al,1			; turn on flag
		lea di, busy_flag		; point
		mov [di], al			; save it
busy_pop:	pop dx				; retsore regs
		pop ax
		ret
busy		endp

unbusy		proc				; make device unbusy
		push ax				; save registers
		push dx
		mov dx,modmcont
		lea di,protocol
		mov al,[di]			; how ?
		cmp al,'1'			; dtr ?
		jnz nunbusy1			; nope
		mov al,busy_stat		; get it
		or al,00001011b			; bit 0 on
		out dx,al			; change line
		mov busy_stat,al		; save status
		jmp unbusy_done			; done
nunbusy1:	cmp al,'2'			; xon/xoff ?
		jnz nunbusy2			; no
		mov al,17			; xon
		call put_com			; send it
		jmp unbusy_done			; done
nunbusy2:	cmp al,'4'			; rts/cts
		jnz unbusy_pop			; no handshake
		mov al,busy_stat		; get old		
		or al,00001011b			; raise rts
		out dx,al			; program it
		mov busy_stat,al		; save status
unbusy_done:	mov al,0			; turn off flag
		lea di, busy_flag
		mov [di], al			; save it
unbusy_pop:	pop dx				; retsore regs
		pop ax
		ret
unbusy		endp
				
code		ends
		end prog
