        /* INIT */
        /* In wires.lib */

        #include <stdio.h>
        #include <rs.h>
        #include <subwires.h>

        logical init(maskfile,option)
        int option;
        char maskfile[];

/****************************************************************
*                                                               *
*       Initialise WIRES:                                       *
*                                                               *
*       (1) Store initial values of the Parallel port.          *
*       (2) Read in the pin-map from the mask file.             *
*                                                               *
*       Option 15:                                              *
*       ---------                                               *
*       Test ready/Set Clear,then Leave in trasmit mode.        *
*                                                               *
*       Option 17:                                              *
*       ---------                                               *
*       Test Clear/Set Ready,then Leave in receive mode.        *
*                                                               *
*       Option 20:                                              *
*       ---------                                               *
*       (3) Send 0,1,2,...128  to  BBC to test transmission.    *
*       (4) Get  0,1,2,...128 from BBC to test reception.       *
*       (5) Leave in trasmit mode.                              *
*                                                               *
*                                 17.03.1995.                   *
****************************************************************/

        {
        FILE *fp;
        byte c,d;
        int i,j,k;
        unsigned long systime0,systime1;
        INIT_DATA=in8(PORT_OUT);
        INIT_STATUS=in8(PORT_IN);
        INIT_CONTROL=in8(PORT_CONTROL);
/**/
        fp=fopen(maskfile,"r");
        if (fp==NULL) {
           puts("Failed to open maskfile:");
           puts(maskfile);
           return(FALSE);
        }
        puts("Reading Maskfile .");
        for (i=0;i<4;i++) {
           if (fscanf(fp,"%d %d %d",&DMASK[i],&j,&k)==NULL) {
              printf("\nBad read of maskfile,on reading DMASK(%d)\n",i);
              return(FALSE);
           }
           if (j!=0 || k!=1) {
              puts("Can only do 0 --> 1 bit detect in V0.0");
              return(FALSE);
           }
        }
        for (i=0;i<4;i++) {
           if (fscanf(fp,"%d %d %d",&SMASK[i],&j,&k)==NULL) {
              printf("\nBad read of maskfile,on reading SMASK(%d)\n",i);
              return(FALSE);
           }
           if (j!=0 || k!=1) {
              puts("Can only do 0 --> 1 bit detect in V0.0");
              return(FALSE);
           }
        }
        fclose(fp);
/**/
        if (option==17) {
           SENDING=FALSE;
           RECEIVING=TRUE;
           puts("Now run BBC program,if not done so..");
           call delay(50);         /* Wait 5 seconds */
           puts("Waiting for BBC holding ...");
           getsyst(&systime0);
           while (Tx()!=0) {                     /* Loop till Ok or Timeout */
              getsyst(&systime1);
              if (systime1>systime0+Timeout) return(10);         /* Give up */
           }           
           if (!Clear_Rx()) {puts("Wrong Tx/Rx mode");return(FALSE);}
           return(TRUE);
        }
        SENDING=TRUE;
        RECEIVING=FALSE;
        puts("Now run BBC program,if not done so..");
        puts("Requesting BBC's attention ....");
        if (!Clear_Tx()) {puts("Wrong Tx/Rx mode");return(FALSE);}
        call delay(50);         /* Wait 5 seconds */
/*      Wait for BBC ready:-                            */
        puts("Waiting for BBC ready ...");
        getsyst(&systime0);
        while (Rx()!=0) {                     /* Loop till Ok or Timeout */
           getsyst(&systime1);
           if (systime1>systime0+Timeout) return(10);         /* Give up */
        }           
        if (option==15) return(TRUE);
        puts("Testing Transmission ....");
        send_stat(ENQ);
        send_stat(SOH); /* ^A (Attention) */        
        send_stat(0);
        puts("Sending.....");
        for (i=1,c=1;i<9;i++,c=c*2) {
           printf("%d,",c);fflush(stdout);
           send_stat(c);
        }
        send_stat(ETX);
/**/
        printf("\n");
        puts("Testing Reception ....");
        if (!over2you()) return(FALSE);        
        get_stat(&c);
        if (c!=0) {
           printf("\nBBC sent a %d instead of a 0\n",c);
           return(FALSE);        
        }
        puts("Receiving.....");
        for (i=1,c=1;i<9;i++,c=c*2) {
           get_stat(&d);printf("%d,",d);fflush(stdout);
           if (d!=c) {
              printf("\nBBC sent a %d instead of a %d\n",d,c);
              return(FALSE);        
           }
        }
        get_stat(&c);
        if (c!=ACK) {
           printf("\nBBC sent a %d instead of an ACK\n",c);
           return(FALSE);        
        }
        get_stat(&c);
        if (c!=DC2) {
           printf("\nBBC sent a %d instead of a DC2\n",c);
           return(FALSE);        
        }
/**/
        if (!back2me()) return(FALSE);
        puts(" ");puts("BBC has responded correctly");
        return(TRUE);
        }
