/* Released to the Public Domain in 1992 by Peter Edward Cann. */


/* Substitution Tokens for Function Sequences */
/* n&0xff00 must be nonzero!!! */

#define END 0x0100
#define BINCOL 0x0101
#define BINROW 0x0102
#define ASCDECCOL 0x0103
#define ASCDECROW 0x0104
#define ASCDECSEMILIST 0x0105
#define GRABCHAR 0x0106
#define GRAPHCHAR_T 0x0107


/* Function Codes for Function Sequences */

#define CLEAR 0
#define HOME 1
#define CLREOL 2
#define UP 3
#define DOWN 4
#define LEFT 5
#define RIGHT 6
#define GOTO 7
#define NORMAL 8
#define FAINT 9
#define NOFAINT 10
#define BOLD 11
#define NOBOLD 12
#define BLINK 13
#define NOBLINK 14
#define INVERSE 15
#define NOINVERSE 16
#define UPN 17
#define DOWNN 18
#define LEFTN 19
#define RIGHTN 20
#define ANSIATTRIB 21
#define WRAP 22
#define NOWRAP 23
#define GOTOLINE 24
#define GOTOCOL 25
#define WYSEATTR 26
#define GRAPHCHAR 27
#define BEGGRAPH 28
#define ENDGRAPH 29
#define TAB 30  /* Non-destructive */
#define BELL 31
#define DTAB 32  /* Destructive */
#define NOOP 33  /* MUST BE HIGHEST FUNCTION NUMBER! */


/* Miscellaneous */

#define NFUNCS 32  /* Number of Sequences */
#define FUNLEN 16

#define KEYLEN 16

struct
	{
	struct
		{
		short codes[FUNLEN];
		short func;
		}
		funcs[NFUNCS];
	struct
		{
		short len;
		unsigned char chars[KEYLEN];
		char nullpause_p;
		}
		keys[256];
	char gchars[256];
	int tophi_p;
	int binrowoff;
	int bincoloff;
	int default_wrap_p;
	}
	emu;

nullemu()
	{
	int i;
	for(i=0;i<NFUNCS;i++)
		{
		emu.funcs[i].func=NOOP;
		emu.funcs[i].codes[0]=END;
		}
	for(i=0;i<256;i++)
		emu.keys[i].len=0;
	for(i=0;i<256;i++)
		emu.gchars[i]=0;
	emu.keys[0x03].len=1;
	emu.keys[0x03].chars[0]='\0';
	emu.default_wrap_p=1;
	}

