
/*      comm.h     */


#define     TRUE           1
#define     FALSE          0
#define     LT            <0
#define     EQ           ==0
#define     GT            >0
#define     NE           !=0

#define     MY_STK_SIZE 1024
#define     LINE_LENGTH   81
#define     MAX_LINES    100

#define     SBUFSIZ     6000
#define     OBUFSIZ     1100

#define     NO_TRANSFER    0
#define     ASCII_RECV     1
#define     ASCII_SEND     2
#define     XMODEM_RECV   11
#define     XMODEM_SEND   12
#define     YMODEM_RECV   21
#define     YMODEM_SEND   22
#define     KERMIT_RECV   31
#define     KERMIT_SEND   32

#define     NORMAL         1
#define     CHAT           2
#define     ANSI           3

#define     ALT           56
#define     RIGHT_SHIFT   54

#define     SOH         0x01
#define     STX         0x02
#define     EOT         0x04
#define     ACK         0x06
#define     NAK         0x15
#define     YSTART       'C'

#define     BELL           7
#define     BS             8
#define     LINEFEED      10
#define     FORMFEED      12
#define     CR            13
#define     TAB            9
#define     BACKTAB       15
#define     CTRLQ         17
#define     CTRLS         19
#define     CTRLX         24
#define     CTRLZ         26
#define     ESC           27

#define     ALTX          45
#define     ALTC          46
#define     ALTS          31
#define     ALTD          32
#define     ALTE          18
#define     ALTF          33
#define     ALTT          20
#define     ALTM          50
#define     ALTH          35
#define     ALT1         120
#define     ALT2         121
#define     ALT3         122
#define     ALT4         123
#define     ALT5         124
#define     ALT6         125
#define     ALT7         126
#define     ALT8         127
#define     ALT9         128
#define     HOMEKEY       71
#define     ENDKEY        79
#define     UPKEY         72
#define     DOWNKEY       80
#define     PGUPKEY       73
#define     PGDNKEY       81
#define     LEFTKEY       75
#define     INSKEY        82
#define     RIGHTKEY      77
#define     DELKEY        83
#define     CTRLLEFTKEY  115
#define     CTRLRIGHTKEY 116
#define     F1            59
#define     F2            60
#define     F3            61
#define     F4            62
#define     F5            63
#define     F6            64
#define     F7            65
#define     F8            66
#define     F9            67
#define     F10           68

#define     BLACK          0
#define     BLUE           1
#define     GREEN          2
#define     CYAN           3
#define     RED            4
#define     MAGENTA        5
#define     BROWN          6
#define     WHITE          7
#define     DARKGRAY       8
#define     LIGHTBLUE      9
#define     LIGHTGREEN    10
#define     LIGHTCYAN     11
#define     LIGHTRED      12
#define     LIGHTMAGENTA  13
#define     YELLOW        14
#define     BRIGHTWHITE   15
#define     BLINK        128
#define     HIGHINTENSITY 15
#define     UNDERLINE      1

#define     MONO           0
#define     CGA            1
#define     EGA            2

#define HWM             SBUFSIZ / 4 * 3
#define LWM             SBUFSIZ / 2
#define XOFF            0x13
#define XON             0x11

#define CTS             0x10
#define DSR             0x20
#define RI              0x40
#define CD              0x80
#define DTR             0x01
#define RTS             0x02
#define OUT2            0x08
#define THR_BUSY        0x20
#define IMR             0x21
#define ICR             0x20
#define EOI             0x20
#define IRQ3            0xf7
#define IRQ4            0xef
#define RX_INT             3
#define RTS_DTR         0x0b

#define MAX_BAUD       38400l
#define NO_PAR             0
#define EV_PAR             1
#define OD_PAR             2

void    do_popup(void);
void    do_transfer(void);
void    actual_popup(void);
int     get_vid_mode(void);
void    getkey(void);
void    vidtype(void);
int     kbdstring(char buff[], int max_chars);
int     fgetbuf(int fh);
int     fgetstring(int fh, char buff[], int max_chars);
void    message(char *s);
void    ask_yn(char *s);
void    beep(void);


/*
 *
 *  kermit prototypes
 *
 *
 */

int    bufemp       (char [], int);
int    bufill       (char []);
int    gnxtfl       (void);
char   rdata        (void);
void   read_tty     (unsigned char *);
void   recsw        (void);
char   rfile        (void);
char   rinit        (void);
char   rpack        (int *, int *, char *);
int    rpar         (char []);
char   sbreak       (void);
char   sdata        (void);
void   sendsw       (void);
char   seof         (void);
char   sfile        (void);
char   sinit        (void);
int    spack        (char, int, int, char *);
int    spar         (char []);
void   write_tty    (char *, int);



