	       INCLUDE MODEL.INC
;
;---------------------------------------------------------------------------
;   Function:	int _bye_check(ver, rev)
;
;   Parms:	int ver = lowest version# acceptable
;		int rev = lowest revison# acceptable
;
;   Purpose:	Test to see if BYE-PC is loaded before executing
;		any other functions. Prevents a system crash!!!
;		If you call any other functions that call BYE-PC
;		interrupt 66h, before '_bye_check() == 1' the system
;		will crash. The interrupt vectors are uninitialized
;		and contain null or garbage data. This checks to
;		make sure that BYE-PC has been loaded.
;
;   Return:	0 = BYE-PC loaded and is acceptable version/revision
;		1 = BYE-PC is not loaded yet
;		2 = BYE-PC is loaded but, invalid version#
;		3 = BYE-PC is loaded but, invalid revision#
;---------------------------------------------------------------------------
;
	       PUBLIC __bye_check

__bye_check    PROC

	       push bp			;standard 'C' function entry
	       mov  bp,sp
	       push si			;save index regs
	       push di
	       push ds			;save seg regs
	       push es
;
; Attempt to locate the resident portion using INT16's segment.
;
	       mov  ax,3516h		;dos get INT16 vector
	       int  21h
	       mov  bx,0103H		;.COM file offset
	       cmp  BYTE PTR es:[bx], 'B'
	       jne  chk_ld
	       inc  bx
	       cmp  BYTE PTR es:[bx], 'Y'
	       jne  chk_ld
	       inc  bx
	       cmp  BYTE PTR es:[bx], 'E'
	       jne  chk_ld
;
; Check version version number of BYE-PC already loaded.
;
	       mov  ax,ARG1		;BH=lowest ver#
	       mov  bh,al
	       mov  ax,ARG2		;BL=lowest rev#
	       mov  bl,al

	       push bx
	       push cx
	       mov  ah,11		;AH=11 BYE-PC get version
	       int  BYE_VECT		;AH=ver, AL=rev
	       pop  cx
	       pop  bx

	       cmp  ah,bh		;if (bye_ver > ver)
	       jg   chk_ok		;  return(0);
	       cmp  ah,bh		;if (bye_ver < ver)
	       jl   chk_ver		;  return(2);
	       cmp  al,bl		;if (bye_rev < rev)
	       jl   chk_ver		;  return(3);
;
; Set the appropriate return code, restore registers, and exit
;
chk_ok:        xor  ax,ax		;0 = no error
	       jmp  SHORT chk_exit
chk_ld:        mov  ax,1		;1 = BYE-PC not loaded
	       jmp  SHORT chk_exit
chk_ver:       mov  ax,2		;2 = bad ver number
	       jmp  SHORT chk_exit
chk_rev:       mov  ax,3		;3 = bad rev number

chk_exit:      pop  es			;restore seg regs
	       pop  ds
	       pop  di			;restore index regs
	       pop  si
	       mov  sp,bp		;standard 'C' exit
	       pop  bp
	       ret

__bye_check    ENDP
	       END

