--  -----------------------------------------------------------------------
--  Title:       Float_elementary_functions
--  Last Mod:    Thu Apr 19 12:40:15 1990
--  Author:      Vincent Broman <broman@nosc.mil>
--   Copyright 1990 Vincent Broman
--     Permission granted to copy, modify, or compile this software for
--   one's own use, provided that this copyright notice is preserved intact.
--     Permission granted to distribute compiled binary copies of this
--   software which are linked in with some other application.
--     Permission granted to distribute other copies of this software,
--   provided that (1) any copy which is not source code, i.e. not in the
--   form in which the software is usually maintained, must be accompanied
--   by a copy of the source code from which it was compiled, and (2) the
--   one distributing it must refrain from imposing on the recipient
--   further restrictions on the distribution of this software.
--   
--  Visibility:  withed by generic_elementary_functions body
--  Description:
--
--      a Float-precision implementation of 
--      the proposed standard generic package of elementary functions, 
--      from the ISO-IEC/JTC1/SC22/WG9 (Ada)
--      Numerics Rapporteur Group proposal, Draft 1.1.
--      
--      mantissa size of 21 to 24 bits assumed.
-- 
--      This will evolve to conform to later drafts.
-- 
--  Exceptions:  argument_error, numeric_error are raised.
--  -----------------------------------------------------------------------
with elementary_functions_exceptions;
package Math is

    function sqrt    ( x         : Float )        return Float;
    function log     ( x         : Float )        return Float;
    function log     ( x , base  : Float )        return Float;
    function exp     ( x         : Float )        return Float;
    function "**"    ( x , y     : Float )        return Float;

    function sin     ( x         : Float )        return Float;
    function sin     ( x , cycle : Float )        return Float;
    function cos     ( x         : Float )        return Float;
    function cos     ( x , cycle : Float )        return Float;
    function tan     ( x         : Float )        return Float;
    function tan     ( x , cycle : Float )        return Float;
    function cot     ( x         : Float )        return Float;
    function cot     ( x , cycle : Float )        return Float;

    function arcsin  ( x         : Float )        return Float;
    function arcsin  ( x , cycle : Float )        return Float;
    function arccos  ( x         : Float )        return Float;
    function arccos  ( x , cycle : Float )        return Float;
    function arctan  ( y         : Float;
		       x         : Float := 1.0 ) return Float;
    function arctan  ( y         : Float;
		       x         : Float := 1.0;
		       cycle     : Float )        return Float;
    function arccot  ( x         : Float;
		       y         : Float := 1.0 ) return Float;
    function arccot  ( x         : Float;
		       y         : Float := 1.0;
		       cycle     : Float )        return Float;

    function sinh    ( x         : Float )        return Float;
    function cosh    ( x         : Float )        return Float;
    function tanh    ( x         : Float )        return Float;
    function coth    ( x         : Float )        return Float;

    function arcsinh ( x         : Float )        return Float;
    function arccosh ( x         : Float )        return Float;
    function arctanh ( x         : Float )        return Float;
    function arccoth ( x         : Float )        return Float;


    argument_error: exception
	renames elementary_functions_exceptions.argument_error;

end Math;

-- $Header: s_elementary_functions_s.ada,v 3.13 90/04/19 12:40:59 broman Rel $
