WITH Ada.Text_IO;
PROCEDURE Work_Days IS
------------------------------------------------------------------
--| Demonstrates the use of enumeration subtypes:
--| prompts user for a day of the week and determines whether
--| the following day is a weekday or weekend day.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE Days IS (Mon, Tue, Wed, Thu, Fri, Sat, Sun);
  SUBTYPE WeekDays IS Days RANGE Mon .. Fri;
  SUBTYPE WeekEnd  IS Days RANGE Sat .. Sun;
  PACKAGE Day_IO IS
     NEW Ada.Text_IO.Enumeration_IO (Enum => Days);

  Today     : Days;
  Tomorrow  : Days;

BEGIN -- Work_Days

  -- prompt user to enter a day abbreviation
  Ada.Text_IO.Put (Item => "Enter a 3-letter day of the week > ");
  Day_IO.Get (Item => Today);

  -- find tomorrow
  IF Today = Days'Last THEN
    Tomorrow := Days'First;
  ELSE
    Tomorrow := Days'Succ(Today);
  END IF;

  Ada.Text_IO.Put (Item => "Tomorrow is ");
  Day_IO.Put (Item => Tomorrow);
  Ada.Text_IO.New_Line;

  -- Is Tomorrow a week day or a weekend day?
  IF Tomorrow IN Weekdays THEN
    Ada.Text_IO.Put (Item => "Another day, another dollar...");
    Ada.Text_IO.New_Line;
  ELSE
    Ada.Text_IO.Put (Item => "We've worked hard, let's play hard!");
    Ada.Text_IO.New_Line;
  END IF;

  Ada.Text_IO.Put (Item => "Have a good day tomorrow.");
  Ada.Text_IO.New_Line;

END Work_Days;
