WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Ada.Integer_Text_IO;
WITH Currency; USE Currency;
WITH Currency.IO;
WITH Maximum_Generic;
PROCEDURE Test_Maximum_Generic IS 
------------------------------------------------------------------
--| Test program for Generic Maximum, using six instances
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  FUNCTION Maximum IS NEW Maximum_Generic (ValueType=>Float,    Compare=> ">");
  FUNCTION Minimum IS NEW Maximum_Generic (ValueType=>Float,    Compare=> "<");

  FUNCTION Maximum IS NEW Maximum_Generic (ValueType=>Integer,  Compare=> ">");
  FUNCTION Minimum IS NEW Maximum_Generic (ValueType=>Integer,  Compare=> "<");
  
  FUNCTION Maximum IS NEW Maximum_Generic (ValueType=>Quantity, Compare=> ">");
  FUNCTION Minimum IS NEW Maximum_Generic (ValueType=>Quantity, Compare=> "<");

BEGIN -- Test_Maximum_Generic

  Ada.Text_IO.Put("Maximum of -3 and 7 is ");
  Ada.Integer_Text_IO.Put(Item => Maximum(-3, 7), Width=>1);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Minimum of -3 and 7 is ");
  Ada.Integer_Text_IO.Put(Item => Minimum(-3, 7), Width=>1);
  Ada.Text_IO.New_Line(Spacing => 2);
  
  Ada.Text_IO.Put("Maximum of -3.29 and 7.84 is ");
  Ada.Float_Text_IO.Put(Item => Maximum(-3.29, 7.84), Fore=>1, Aft=>2, Exp=>0);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Minimum of -3.29 and 7.84 is ");
  Ada.Float_Text_IO.Put(Item => Minimum(-3.29, 7.84), Fore=>1, Aft=>2, Exp=>0);
  Ada.Text_IO.New_Line(Spacing => 2);
  
  Ada.Text_IO.Put("Maximum of 23.65 and 37.49 is ");
  Currency.IO.Put(Item => Maximum(MakeCurrency(23.65), MakeCurrency(37.49)));
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Minimum of 23.65 and 37.49 is ");
  Currency.IO.Put(Item => Minimum(MakeCurrency(23.65), MakeCurrency(37.49)));
  Ada.Text_IO.New_Line(Spacing => 2);

END Test_Maximum_Generic; 
