WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Sum_Integers IS
------------------------------------------------------------------
--| Finds and displays the sum of all positive integers from 1 to N.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
 
  N   : Positive;            -- input  - the last integer added
  Sum : Natural;             -- output - the sum being accumulated
 
BEGIN -- Sum_Integers   

  -- Read the last integer, N   
  Ada.Text_IO.Put (Item => "Enter the last integer in the sum > ");
  Ada.Integer_Text_IO.Get (Item => N);  
 
  -- Find the sum (Sum) of all integers from 1 to N   
  Sum := 0;            -- Initialize Sum to 0
  FOR I IN 1 .. N LOOP
    Sum := Sum + I;    -- Add the next integer to Sum  
  END LOOP;
 
  -- Display the sum   
  Ada.Text_IO.Put (Item => "The sum of the integers from 1 to ");
  Ada.Integer_Text_IO.Put (Item => N, Width => 1);  
  Ada.Text_IO.Put (Item => " is ");
  Ada.Integer_Text_IO.Put (Item => Sum, Width => 1);  
  Ada.Text_IO.New_Line;

END Sum_Integers;
