WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Ada.Numerics.Elementary_Functions;
PROCEDURE Square_Roots IS
------------------------------------------------------------------
--| Illustrates the square root function provided by 
--| the standard Ada math function package.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;

  First : NonNegFloat;
  Second: NonNegFloat;
  Answer: NonNegFloat;

BEGIN  -- Square_Roots   

  Ada.Text_IO.Put (Item => "Please enter first number > ");
  Ada.Float_Text_IO.Get(Item => First);
  Answer := Ada.Numerics.Elementary_Functions.Sqrt(First);
  Ada.Text_IO.Put (Item => "The first number's square root is ");
  Ada.Float_Text_IO.Put (Item => Answer, Fore => 1, Aft => 5, Exp => 0);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put (Item => "Please enter second number > ");
  Ada.Float_Text_IO.Get(Item => Second);
  Ada.Text_IO.Put (Item => "The second number's square root is ");
  Ada.Float_Text_IO.Put 
    (Item => Ada.Numerics.Elementary_Functions.Sqrt (Second), 
     Fore => 1, Aft => 5, Exp => 0);
  Ada.Text_IO.New_Line;

  Answer := Ada.Numerics.Elementary_Functions.Sqrt(First + Second);
  Ada.Text_IO.Put (Item => "The square root of the sum of the numbers is ");
  Ada.Float_Text_IO.Put (Item => Answer, Fore => 1, Aft => 5, Exp => 0);
  Ada.Text_IO.New_Line;

END Square_Roots;
