PACKAGE Spiders IS
------------------------------------------------------------------
--| This package provides procedures to emulate multiple           
--| spiders. The spiders can move around        
--| the screen drawing simple patterns.                           
--| Author: John Dalbey, Cal Poly San Luis Obispo, 1992
--| Adapted by: Michael B. Feldman, The George Washington University
--| Last Modified: July 1995
------------------------------------------------------------------

  TYPE Switch       IS (On, Off);                   
  TYPE Directions IS (North, East, South, West);
  TYPE ScreenColors IS (Red, Blue, Green, Black);  

  MaxHeight: Positive := 20;
  MaxWidth:  Positive := 20;
  SUBTYPE RoomHeight IS Positive RANGE 1..MaxHeight;
  SUBTYPE RoomWidth  IS Positive RANGE 1..MaxWidth;

  TYPE Spider IS PRIVATE;

  Hit_The_Wall: EXCEPTION;
  
  PROCEDURE DrawRoom;
  -- Pre:  None
  -- Post: Spider's room appears on the screen 

  PROCEDURE Start (Which: IN OUT Spider; 
                   Row: IN RoomHeight; Col: IN RoomWidth;
                   WhichColor: IN ScreenColors; WhichWay: IN Directions);
  -- Pre:  None
  -- Post: Spider appears in the given position.

  PROCEDURE Blue  (Which: IN OUT Spider);
  PROCEDURE Green (Which: IN OUT Spider);
  PROCEDURE Red   (Which: IN OUT Spider);
  PROCEDURE Black (Which: IN OUT Spider);
  -- Pre:  None
  -- Post: Change the color of ink with which the spider draws
  --   On black-and-white screen, uses different characters
  --   to represent the colors.

  PROCEDURE Face (Which: IN OUT Spider; WhichWay: IN Directions);
  -- Pre:  WhichWay has been assigned a value
  -- Post: Spider turns to face the given direction.

  FUNCTION IsFacing (Which: Spider) RETURN Directions;
  -- Pre:  None
  -- Post: Returns the direction the spider is facing.

  PROCEDURE Step (Which: IN OUT Spider);
  -- Pre:  None
  -- Post: Spider takes one step forward in the direction it is facing.
  -- Raises: Hit_the_Wall is if spider tries to step into a wall.

  PROCEDURE Jump (Which: IN OUT Spider; HowMany: IN Positive);
  -- Pre:  None
  -- Post: Spider jumps forward the given number of steps, without
  --   leaving tracks at each step.
  -- Raises: Hit_the_Wall if spider tries to step into or over a wall.

  PROCEDURE Right (Which: IN OUT Spider);
  -- Pre:  None
  -- Post: Spider turns 90 degrees to the right.

  FUNCTION  AtWall (Which: Spider) RETURN Boolean;
  -- Pre:  None
  -- Post: Returns True if the spider is standing next to a wall 
  --   (edge of the room) and facing it, and False otherwise.

  FUNCTION  NearWall (Which: Spider; HowMany: Positive) RETURN Boolean;
  -- Pre:  None
  -- Post: Returns True if the spider is standing within
  --   HowMany steps of a wall and facing it, and False otherwise.

  PROCEDURE Quit;
  -- Pre:  None
  -- Post: End the drawing

  PROCEDURE Debug (Setting: Switch);
  -- Pre:  None
  -- Post: Turns on or off single stepping through the program.

  FUNCTION  Debugging RETURN Switch; 
  -- Pre:  None
  -- Post: Returns on or Off depending on Debug setting

PRIVATE

  TYPE Spider IS RECORD
    Ink           : ScreenColors;
    Heading       : Directions;
    CurrentColumn : RoomWidth;               -- spider's position
    CurrentRow    : RoomHeight;              --      in the room.
  END RECORD;

END Spiders;
