WITH Swap_Generic;
PROCEDURE Sort_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------
--| Body of Generic Sort Procedure
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  -- we need to make an instance of Swap_Generic for this case
  PROCEDURE Exchange IS NEW Swap_Generic (ValueType => ElementType);

  IndexOfMax: IndexType;

BEGIN -- Sort_Generic

  FOR PositionToFill IN List'First .. IndexType'Pred(List'Last) LOOP

    IndexOfMax := PositionToFill;

    FOR ItemToCompare IN IndexType'Succ(PositionToFill) .. List'Last LOOP
      IF Compare(List(ItemToCompare),  List(PositionToFill)) THEN
        IndexOfMax := ItemToCompare;
      END IF;
    END LOOP;
    
    IF IndexOfMax /= PositionToFill  THEN
      Exchange(List(PositionToFill), List(IndexOfMax));
    END IF;

  END LOOP;

END Sort_Generic;
