PACKAGE BODY Sets_Generic IS
------------------------------------------------------------------
--| Body of generic sets package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  -- constructors

  FUNCTION "+" (S: Set; E: Universe) RETURN Set IS
    Result: Set := S;
  BEGIN -- "+"
    Result.Store (E) := True;
    RETURN Result;
  END "+";

  FUNCTION "-" (S: Set; E: Universe) RETURN Set IS
    Result: Set := S;
  BEGIN -- "-"
    Result.Store (E) := False;
    RETURN Result;
  END "-";

  FUNCTION Singleton(E: Universe) RETURN Set IS
  BEGIN -- Singleton
    RETURN Phi + E;
  END Singleton;

  FUNCTION "+" (E1, E2: Universe) RETURN Set IS
  BEGIN -- "+"
    RETURN Phi + E1 + E2;
  END "+";

  FUNCTION "+" (S, T : Set) RETURN Set IS
    Result: Set;
  BEGIN -- "+"
    FOR E IN Universe LOOP
      Result.Store(E) := S.Store(E) OR T.Store(E);
    END LOOP;
    RETURN Result;
  END "+";

  FUNCTION "*" (S, T : Set) RETURN Set IS
    Result: Set;
  BEGIN -- "*"
    FOR E IN Universe LOOP
      Result.Store(E) := S.Store(E) AND T.Store(E);
    END LOOP;
    RETURN Result;
  END "*";

  FUNCTION "-" (S, T : Set) RETURN Set IS
    Result: Set;
  BEGIN -- "-"
    FOR E IN Universe LOOP
      Result.Store(E) := S.Store(E) AND NOT T.Store(E);
    END LOOP;
    RETURN Result;
  END "-";

  FUNCTION "-" (S : Set) RETURN Set IS
    Result: Set;
  BEGIN -- "-"
    FOR E IN Universe LOOP
      Result.Store(E) := NOT S.Store(E);
    END LOOP;
    RETURN Result;
  END "-";

  -- selectors

  FUNCTION IsIn (S : Set; E : Universe) RETURN Boolean IS
  BEGIN -- IsIn
    RETURN S.Store (E);
  END IsIn;

  FUNCTION IsEmpty (S : Set) RETURN Boolean IS
  BEGIN -- IsEmpty
    RETURN S = Phi;
  END IsEmpty;

  FUNCTION SizeOf (S : Set) RETURN Natural IS
    Result: Natural := 0;
  BEGIN -- SizeOf
    FOR E IN Universe LOOP
      IF S.Store(E) THEN
    Result := Result + 1;
      END IF;
    END LOOP;
    RETURN Result;
  END SizeOf;

  FUNCTION "<=" (S, T : Set) RETURN Boolean IS
  BEGIN -- "<="
    RETURN (S + T) = T;
    RETURN True;
  END "<=";

  FUNCTION "<" (S, T : Set) RETURN Boolean IS
  BEGIN -- "<"
    RETURN S /= T AND THEN S <= T;
  END "<";

END Sets_Generic;
