FUNCTION Search (Scores: ScoreArray; ClassSize: ClassRange; 
                 Target: ScoreRange) RETURN ClassRange IS

   -- Searches for Target in array Scores
   -- Pre : ClassSize and subarray Scores(1..ClassSize) are defined
   -- Post: Returns the subscript of Target if found;
   --    otherwise, returns 0

   CurrentScore: ClassIndex;       -- array subscript   


BEGIN  -- Search   

  -- Compare each value in Scores to Target until done  
  CurrentScore := 1;            -- Start with the first record   
  WHILE (Scores(CurrentScore) /= Target) AND (CurrentScore <= ClassSize) LOOP
  -- invariant:
  -- CurrentScore <= ClassSize + 1 and
  -- no prior array element was Target

      CurrentScore := CurrentScore + 1; -- advance to next score

  END LOOP;
  -- assertion: Target is found or last element is reached.    

  -- Define the function result.   
  IF Scores(CurrentScore) = Target THEN
    RETURN CurrentScore;
  ELSE
    RETURN 0;
  END IF;

END Search;
