WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Nested_Loops IS
------------------------------------------------------------------
--| Illustrates a pair of nested FOR loops.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

BEGIN -- Nested_Loops   

  Ada.Text_IO.Put(Item => "         OuterCounter  InnerCounter"); 
  Ada.Text_IO.New_Line;

  FOR OuterCounter IN 1 .. 3 LOOP

    Ada.Text_IO.Put(Item => "OUTER");
    Ada.Integer_Text_IO.Put(Item => OuterCounter, Width => 10);  
    Ada.Text_IO.New_Line;

    FOR InnerCounter IN 1 .. OuterCounter LOOP
      Ada.Text_IO.Put(Item => "  INNER");
      Ada.Integer_Text_IO.Put(Item => InnerCounter, Width => 22);  
      Ada.Text_IO.New_Line;
    END LOOP;

  END LOOP;      

END Nested_Loops;
