WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
WITH Useful_Functions;
PROCEDURE Max_Int_Flt IS
------------------------------------------------------------------
--| illustrates the overloading principle using the Maximum 
--| functions for both integer and float quantities
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
 
  Int1 :      Integer; -- inputs
  Int2 :      Integer;
  LargerInt : Integer; -- output

  Flt1 :      Float;   -- inputs
  Flt2 :      Float;  
  LargerFlt : Float;   -- output

BEGIN -- Max_Int_Flt

  Ada.Text_IO.Put (Item => "Please enter first integer value  > ");
  Ada.Integer_Text_IO.Get (Item => Int1);
  Ada.Text_IO.Put (Item => "Please enter second integer value > ");
  Ada.Integer_Text_IO.Get (Item => Int2);
  
  LargerInt := Useful_Functions.Maximum(Value1=>Int1, Value2=>Int2);
  
  Ada.Text_IO.Put (Item => "The larger integer is ");
  Ada.Integer_Text_IO.Put (Item => LargerInt, Width => 1);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put (Item => "Please enter first float value  > ");
  Ada.Float_Text_IO.Get (Item => Flt1);
  Ada.Text_IO.Put (Item => "Please enter second float value > ");
  Ada.Float_Text_IO.Get (Item => Flt2);
  
  LargerFlt := Useful_Functions.Maximum(Value1=>Flt1, Value2=>Flt2);
  
  Ada.Text_IO.Put (Item => "The larger float is ");
  Ada.Float_Text_IO.Put (Item => LargerFlt, Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;

END Max_Int_Flt; 
