WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Free_Fall IS
------------------------------------------------------------------
--| Displays the height of an object dropped
--| from a tower until it its the ground.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;
  
  g : CONSTANT NonNegFloat := 9.80665;      -- gravitational constant
 
  Height: Float;         -- input - height of object   
  Tower:  NonNegFloat;   -- input - height of tower   
  DeltaT: NonNegFloat;   -- input - time interval   

  t:      NonNegFloat;   -- output - elapsed time   
 
BEGIN -- Free_Fall

  -- Enter tower height and time interval.   
  Ada.Text_IO.Put(Item => "Please enter all values in floating-point form.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "Tower height in meters > ");
  Ada.Float_Text_IO.Get(Item => Tower);   
  Ada.Text_IO.Put(Item => "Time in seconds between table lines > ");
  Ada.Float_Text_IO.Get(Item => DeltaT);  
  Ada.Text_IO.New_Line(Spacing => 2);
 
  -- Display object height until it hits the ground.   
  Ada.Text_IO.Put(Item => "        Time      Height");  
  Ada.Text_IO.New_Line;

  t := 0.0;
  Height := Tower;

  WHILE Height > 0.0 LOOP
    Ada.Float_Text_IO.Put(Item => t, Fore => 8, Aft => 3, Exp => 0);
    Ada.Float_Text_IO.Put(Item => Height, Fore => 8, Aft => 3, Exp => 0);  
    Ada.Text_IO.New_Line;
    t := t + DeltaT;
    Height := Tower - 0.5 * g * (t ** 2);
  END LOOP;
 
  -- Object hits the ground.   
  Ada.Text_IO.New_Line;  
  Ada.Text_IO.Put(Item => "SPLATT!!!");  
  Ada.Text_IO.New_Line;

END Free_Fall;
