WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Ada.Integer_Text_IO;
WITH Dates.IO;
WITH Currency.IO;
PACKAGE BODY Employees.IO IS
------------------------------------------------------------------
--| Body of Child Package for Employee Input/Output
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: July 1995        
------------------------------------------------------------------

  PACKAGE GenderType_IO IS 
    NEW Ada.Text_IO.Enumeration_IO(Enum => GenderType);

  PROCEDURE ReadEmployee (Item: OUT Employee) IS

    S: String(1..MaxName);
    Count: Natural;

  BEGIN -- simple, non-robust ReadEmployee   
  
    Ada.Text_IO.Put(Item => "ID > ");  
    Ada.Integer_Text_IO.Get(Item => Item.ID);  
    Ada.Text_IO.Skip_Line;

    Ada.Text_IO.Put(Item => "Name > ");
    Ada.Text_IO.Get_Line(Item => S, Last => Count);
    Item.Name(1..Count) := S(1..Count);

    Ada.Text_IO.Put(Item => "Gender (Female or Male) > ");  
    GenderType_IO.Get(Item => Item.Gender);

    Ada.Text_IO.Put(Item => "Number of dependents > ");
    Ada.Integer_Text_IO.Get(Item => Item.NumDepend);

    Ada.Text_IO.Put(Item => "Salary > ");
    Currency.IO.Get(Item => Item.Salary);

    Ada.Text_IO.Put(Item => "Starting Date, mmm dd yyyy > ");
    Dates.IO.Get(Item => Item.StartDate);
  
  END ReadEmployee;

  PROCEDURE DisplayEmployee (Item: IN Employee) IS

  BEGIN -- simple DisplayEmployee

    Ada.Integer_Text_IO.Put(Item => Item.ID, Width => 1);  
    Ada.Text_IO.New_Line;
    Ada.Text_IO.Put(Item => Item.Name);
    Ada.Text_IO.New_Line;
    GenderType_IO.Put(Item => Item.Gender);
    Ada.Text_IO.New_Line;
    Ada.Integer_Text_IO.Put(Item => Item.NumDepend, Width => 1);
    Ada.Text_IO.New_Line;
    Currency.IO.Put(Item => Item.Salary);
    Ada.Text_IO.New_Line;
    Dates.IO.Put(Item => Item.StartDate, Format => Dates.IO.Full);
    Ada.Text_IO.New_Line;

  END DisplayEmployee;

END Employees.IO;
