PACKAGE BODY Employees IS
------------------------------------------------------------------
--| Body of ADT package to handle Employee records
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  -- operations

  -- constructor

  FUNCTION MakeEmployee (ID:        IDType;
                         Name:      NameType;
                         Gender:    GenderType;
                         NumDepend: Natural;
                         Salary:    Currency.Quantity;
                         StartDate: Dates.Date)  RETURN Employee IS

    TempRecord: Employee;

  BEGIN -- MakeEmployee

    TempRecord := 
      (ID => ID, Name => Name, Gender => Gender,
       NumDepend => NumDepend, Salary => Salary, StartDate => StartDate);
    RETURN TempRecord;

  END MakeEmployee;

  FUNCTION RetrieveID (OneEmp: Employee) RETURN IDType IS
  BEGIN
    RETURN OneEmp.ID;
  END RetrieveID;

  FUNCTION RetrieveName (OneEmp: Employee) RETURN NameType IS
  BEGIN
    RETURN OneEmp.Name;
  END RetrieveName;

  FUNCTION RetrieveGender (OneEmp: Employee) RETURN GenderType IS
  BEGIN
    RETURN OneEmp.Gender;
  END RetrieveGender;

  FUNCTION RetrieveNumDepend (OneEmp: Employee) RETURN Natural IS   
  BEGIN
    RETURN OneEmp.NumDepend;
  END RetrieveNumDepend;

  FUNCTION RetrieveSalary (OneEmp: Employee) RETURN Currency.Quantity IS
  BEGIN
    RETURN OneEmp.Salary;
  END RetrieveSalary;

  FUNCTION RetrieveDate (OneEmp: Employee) RETURN Dates.Date IS
  BEGIN
    RETURN OneEmp.StartDate;
  END RetrieveDate;

END Employees;
