PACKAGE Currency IS
------------------------------------------------------------------
--| Specification of the abstract data type for representing
--| and manipulating Currency numbers.
--| All values of type Currency.Quantity are initialized to 0.0.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  SUBTYPE CentsType IS Integer RANGE 0..99;
  TYPE    Quantity  IS PRIVATE;

  -- Operations 

  FUNCTION MakeCurrency (F : Float)    RETURN Quantity;
  -- constructor:
  -- Pre : F is defined
  -- Post: returns a Currency Quantity

  FUNCTION MakeFloat    (Q : Quantity) RETURN Float;
  -- constructor:
  -- Pre:  Q is defined
  -- Post: returns the value of Q in Float form
  
  FUNCTION Dollars   (Q : Quantity) RETURN Natural;
  FUNCTION Cents     (Q : Quantity) RETURN CentsType;
  FUNCTION IsPositive(Q : Quantity) RETURN Boolean;
  -- selectors:
  -- Pre:  Q is defined
  -- Post: Dollars returns the Dollars part of Q; Cents the Cents part
    
  FUNCTION "<" (Q1 : Quantity; Q2 : Quantity) RETURN Boolean;
  FUNCTION ">" (Q1 : Quantity; Q2 : Quantity) RETURN Boolean;
  FUNCTION "<="(Q1 : Quantity; Q2 : Quantity) RETURN Boolean;
  FUNCTION ">="(Q1 : Quantity; Q2 : Quantity) RETURN Boolean;
  -- inquiry operators:
  -- Pre : Q1 and Q2 are defined
  -- Post: return Q1 < Q2, Q1 > Q2, Q1 <= Q2, and Q1 >= Q2, respectively
   
  FUNCTION "+"  (Q  : Quantity) RETURN Quantity;
  FUNCTION "-"  (Q  : Quantity) RETURN Quantity;
  FUNCTION "ABS"(Q  : Quantity) RETURN Quantity;
  -- monadic arithmetic constructors:
  -- Pre:  Q is defined
  -- Post: return Q, -Q, ABS Q respectively
  
  FUNCTION "+"  (Q1 : Quantity; Q2 : Quantity) RETURN Quantity;
  FUNCTION "-"  (Q1 : Quantity; Q2 : Quantity) RETURN Quantity;
  FUNCTION "*"  (F  : Float;    Q  : Quantity) RETURN Quantity;
  FUNCTION "*"  (Q  : Quantity; F  : Float   ) RETURN Quantity;
  FUNCTION "/"  (Q1 : Quantity; Q2 : Quantity) RETURN Float;
  FUNCTION "/"  (Q  : Quantity; F  : Float   ) RETURN Quantity;
  -- dyadic arithmetic constructors:
  -- Pre : Q1 and Q2 are defined
  -- Post: these are the sensible arithmetic operators on Quantity.
  --   Note that multiplying two monetary values is not sensible.

PRIVATE

-- A record of type Quantity consists of a pair of Natural values
-- such that the first number represents the Dollars part
-- and the second number represents the Cents part.
-- The sign of a Quantity value is indicated by a Boolean field
-- called Positive.

  TYPE Quantity IS RECORD
    Positive: Boolean   := True;
    Dollars : Natural   := 0;
    Cents   : CentsType := 0;
  END RECORD; -- Quantity

END Currency;
