WITH Ada.Text_IO;
PROCEDURE Copy_File IS
------------------------------------------------------------------
--| Program copies its input file test.dat into its output file 
--| test.out, then closes test.out, re-opens it for input,  
--| and displays its contents on the screen.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: November 1995                                     
------------------------------------------------------------------

  InData  : Ada.Text_IO.File_Type;
  OutData : Ada.Text_IO.File_Type;
  NextCh  : Character;

BEGIN -- Copy_File

  -- open input file; create output file
  Ada.Text_IO.Open
    (File=>InData, Mode=>Ada.Text_IO.In_File, Name=>"test.dat");
  Ada.Text_IO.Create
    (File=>OutData, Mode=>Ada.Text_IO.Out_File, Name=>"test.out");

  -- copy input file to output file, character by character
  WHILE NOT Ada.Text_IO.End_of_File(File => InData) LOOP
    WHILE NOT Ada.Text_IO.End_of_Line(File => InData) LOOP

      Ada.Text_IO.Get(File => InData, Item => NextCh);
      Ada.Text_IO.Put(File => OutData, Item => NextCh);

    END LOOP;

    Ada.Text_IO.Skip_Line(File => InData);
    Ada.Text_IO.New_Line(File => OutData);
  END LOOP;

  Ada.Text_IO.Close(File => InData);
  Ada.Text_IO.Close(File => OutData);

  -- reopen the new file and display it on the screen
  Ada.Text_IO.Open
    (File=>InData, Mode=>Ada.Text_IO.In_File, Name=>"test.out");

  WHILE NOT Ada.Text_IO.End_of_File(File => InData) LOOP
    WHILE NOT Ada.Text_IO.End_of_Line(File => InData) LOOP

      Ada.Text_IO.Get(File => InData, Item => NextCh);
      Ada.Text_IO.Put(Item => NextCh);

    END LOOP;

    Ada.Text_IO.Skip_Line(File => InData);
    Ada.Text_IO.New_Line;
  END LOOP;

  Ada.Text_IO.Close(File => InData);

EXCEPTION

  WHEN Ada.Text_IO.Name_Error =>
    Ada.Text_IO.Put(Item => "File test.dat doesn't exist in this directory!");
    Ada.Text_IO.New_Line;

END Copy_File;
