WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Addition_Table IS
------------------------------------------------------------------
--| Displays an addition table.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  MaxDigit : CONSTANT Natural := 9;           -- largest digit   
  SUBTYPE SmallNatural IS Natural RANGE 0 .. MaxDigit;

BEGIN  -- Addition_Table   

  -- Display the table heading.   
  Ada.Text_IO.Put(Item => "+");
  FOR Right IN SmallNatural LOOP                   -- Display heading
    Ada.Integer_Text_IO.Put(Item => Right, Width => 3);  
  END LOOP;
  Ada.Text_IO.New_Line;                            -- Terminate heading   

  -- Display the table body.   
  FOR Left IN SmallNatural LOOP

    -- Display each row of the table   
    Ada.Integer_Text_IO.Put(Item => Left, Width => 1);   

    FOR Right IN SmallNatural LOOP
      Ada.Integer_Text_IO.Put(Item => Left + Right, Width => 3); 
    END LOOP;

    Ada.Text_IO.New_Line;                          -- Terminate table row   

  END LOOP;

END Addition_Table;
