WITH Ada.Text_IO;
PACKAGE VStrings.IO IS
------------------------------------------------------------------
--| input/output for variable-length strings
--| input is done using Ada.Text_IO.Get_Line, so the rules for
--|   this procedure are followed.
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  PROCEDURE Get_Line(Item : OUT VString; MaxLength: IN Positive);
  -- Pre:  MaxLength is defined
  -- Post: Item contains the contents of the next line entered
  --   from the keyboard.

  PROCEDURE Get_Line(File: Ada.Text_IO.File_Type; 
		     Item: OUT VString; MaxLength: IN Positive);
  -- Pre:  File and MaxLength are defined
  -- Post: Item contains the contents of the next line of the file.

  PROCEDURE Put(File: Ada.Text_IO.File_Type; Item : VString);
  -- Pre:  File and Item are defined
  -- Post: Item is written to the file

  PROCEDURE Put(Item : VString);
  -- Pre:  Item is defined
  -- Post: Item is displayed on the screen.

END VStrings.IO;
