WITH Ada.Text_IO;
PACKAGE BODY VStrings.IO IS
------------------------------------------------------------------
--| Body of I/O package for variable-length strings
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  PROCEDURE Get_Line(File : Ada.Text_IO.File_Type; 
		     Item : OUT VString; MaxLength: IN Positive) IS

    -- reads a VString object from File, using Ada.Text_IO.Get_Line
    -- reading stops if a line terminator is encountered, or if
    -- MaxLength characters have been read.

    S     : String(1..MaxLength);
    Count : Natural;

  BEGIN

    Ada.Text_IO.Get_Line(File => File, Item => S, Last => Count);
    IF Count > 0 THEN
      Item := MakeVstring(S(1..Count), MaxLength => MaxLength);
    ELSE
      Item := EmptyVstring(MaxLength => MaxLength);
    END IF;

  END Get_Line;

  PROCEDURE Get_Line(Item : OUT VString; MaxLength: IN Positive) IS
  BEGIN
    Get_Line(File => Ada.Text_IO.Standard_Input, 
	     Item => Item, MaxLength => MaxLength);
  END Get_Line;

  PROCEDURE Put(File: Ada.Text_IO.File_Type; Item : VString) IS
  BEGIN
    Ada.Text_IO.Put(File=>File, Item=>Value(Item));
  END Put;

  PROCEDURE Put(Item : VString) IS
  BEGIN
    Put(File=>Ada.Text_IO.Standard_Output, Item=>Item);
  END Put;

END VStrings.IO;
