GENERIC

  TYPE KeyType        IS PRIVATE;
  TYPE NonKeyInfoType IS PRIVATE;

  WITH FUNCTION "<" (Left, Right : KeyType) RETURN Boolean;
  WITH PROCEDURE DisplayKey (K : IN KeyType);
  WITH PROCEDURE DisplayRef (N : IN NonKeyInfoType);

PACKAGE Trees_Xref_Generic IS
------------------------------------------------------------------------
--| Soecification for Cross-Reference-Tree Package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  TYPE Tree IS LIMITED PRIVATE;

  PROCEDURE Insert (T : IN OUT Tree;
                    K : KeyType;
                    N : NonKeyInfoType);
  -- Pre:  T, K, N are defined
  -- Post: T is returned with K and N stored in a node in
  --       its proper place in T.

  PROCEDURE Display (T : Tree);
  -- Pre:  T is defined
  -- Post: The contents of T are displayed in key order

PRIVATE

  TYPE BinaryTreeNode;
  TYPE Tree IS ACCESS BinaryTreeNode;

END Trees_Xref_Generic;
