WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Test_Factorial IS
------------------------------------------------------------------
--| Display the factorials of several natural numbers
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------

  FUNCTION Factorial (N : IN Positive) RETURN Positive IS
  
  -- Computes the factorial of N (N!) recursively
  -- Pre : N is defined
  -- Post: returns N!
  
  BEGIN  -- Factorial   

    IF N = 1 THEN
      RETURN 1;                   -- stopping case   
    ELSE
      RETURN N * Factorial(N-1);  -- recursion   
    END IF;

  END Factorial;

BEGIN -- Test_Factorial

  Ada.Text_IO.Put(Item => "  N          N!");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "---------------");
  Ada.Text_IO.New_Line;
  
  FOR Num IN 1..20 LOOP
  
    Ada.Integer_Text_IO.Put(Item => Num, Width => 3);
    Ada.Integer_Text_IO.Put(Item => Factorial(Num), Width => 11);
    Ada.Text_IO.New_Line;
    
  END LOOP;
  
END Test_Factorial;
