WITH Swap_Generic;
PROCEDURE Sort_LinearInsertion_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------------
--| Body of generic Linear Insertion Sort
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);
  
  Top:        IndexType := List'First;
  Bottom:     IndexType := List'Last;
  Position:   IndexType;
 
BEGIN -- Sort_LinearInsertion_Generic
 
    FOR CurrentBottom IN Top+1..Bottom LOOP
      Position := CurrentBottom;
          
      WHILE Position /= Top 
        AND THEN KeyOf(List(Position)) < KeyOf(List(Position-1)) LOOP
          
        Exchange(List(Position), List(Position - 1));
        Position := Position - 1;
      END LOOP;

    END LOOP;

END Sort_LinearInsertion_Generic;
