WITH Heaps_Generic;
WITH Swap_Generic;
PROCEDURE Sort_Heap_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------------
--| Body of Generic Heap Sort Procedure
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);
  
  PACKAGE Heaps IS NEW Heaps_Generic
    (ElementType => ElementType,
     IndexType => IndexType,
     ListType => ListType,
     KeyType => KeyType);
  USE Heaps;
  
BEGIN -- Sort_Heap_Generic
 
  -- first build a heap

  FOR WhichElement IN List'First..List'Last LOOP
    ExtendHeap(List(List'First..WhichElement));
  END LOOP;

  -- now sort the heap

  FOR WhichElement IN REVERSE List'First..List'Last LOOP
    Exchange(List(List'First),List(WhichElement));
    AlmostHeapToHeap(List(List'First..WhichElement-1));
  END LOOP;
 
END Sort_Heap_Generic;
