WITH Queues_Circular_Generic; 
WITH Queues_Priority_Generic;
PROCEDURE Simulation IS
------------------------------------------------------------------------
--| Sketch of event-driven simulation
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  NumQueues : CONSTANT Positive := -- number of open checkouts

  TYPE CustomerRecord IS RECORD -- put these records on the queues
    ArrivalTime: Positive;
    NumItems:    Positive;
  END RECORD;

  PACKAGE MarketQueues IS
    NEW Queues_Circular_Generic (Element => CustomerRecord);
  USE MarketQueues;

  TYPE Market IS ARRAY(1..NumQueues) OF Queue;
  Queues: Market;

  TYPE EventType IS (Arrival, Departure);

  TYPE Event (...) IS RECORD -- these records go on the event list

			-- remember that an arrival event holds
      ...               -- an arrival time and number of items
			-- and a departure event holds a departure
  END RECORD;           -- time and a queue number

  PACKAGE EventQueues IS NEW Queues_Priority_Generic (Element => Event);

  EventList: EventQueue (Capacity => 4);
  
  PROCEDURE ProcessArrival(ArrivalTime: IN Positive;                       
			   NumItems:    IN Positive) IS SEPARATE;  
  
  PROCEDURE ProcessDeparture(DepartureTime: IN Positive;                            
			     Q: IN OUT Queue) IS SEPARATE;
  
BEGIN -- main simulation  
    
  -- initialize queues, event list, other variables  
  -- read ArrivalTime and NumItems from customer file  
  -- place arrival event on event list  
    
  WHILE -- there are still events on the event list LOOP    
    
    -- remove first event from event list    
    IF -- this event is an arrival event  THEN      
      ProcessArrival( -- pass time, number of items );    
    ELSE -- it is a departure event      
      ProcessDeparture( -- pass time, which queue );             
    END IF;  
    
  END LOOP;  
    
  -- compute and print average checkout time
    
END Simulation;
