PROCEDURE PrintPermutations (S : IN Set;
                             K : IN Positive) IS
-- Pre:  S and K are defined
-- Post: displays all permutations of S with members
--   1..K-1 held constant and members K..N varying
  
  N  : Positive   := SizeOf(S);
  S1 : Set (1..N) := CopySet(S);
    -- The local variable is used here so the input set
    -- S doesn't get changed.

BEGIN

  IF K = N THEN            -- stopping case
    PrintSet (S1);
  ELSE
    FOR I IN K .. N LOOP   -- recursive case

      Interchange (S1, I, K);
      PrintPermutations (S1, K + 1);
      -- this recursive call prints all permutations of
      -- the Set with the 1st through k-th members held
      -- constant and the k+1st through N-th varying.

    END LOOP;
  END IF;

END PrintPermutations;
