WITH Persons; USE Persons;
WITH Dates; USE Dates;
PACKAGE Personnel IS
------------------------------------------------------------------
--| specification for Personnel, which provides a type Employee,
--| a derivative of Persons.Person. Note that the operations on
--| objects of type Persons.Person are inherited by objects of
--| type Employee, so we need selectors only for the new
--| fields! As in the case of Persons, we place the constructor
--| in an inner package.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
  
  TYPE Employee IS NEW Person WITH PRIVATE;
    -- Here is where Employee is derived; the extension fields are
    -- also PRIVATE, so clients cannot access them directly.
    
  TYPE IDType IS NEW Positive RANGE 1111..9999;
  
  -- selectors

  FUNCTION StartOf (Whom: Employee) RETURN Date;        
  FUNCTION IDOf    (Whom: Employee) RETURN IDType;
    -- Pre:  Whom is defined
    -- Post: return the appropriate field values
                      
  PROCEDURE Put(Item: Employee);
    -- Pre:  Item is defined
    -- Post: Item is displayed
  
  PACKAGE Constructors IS
  
    -- as in Persons, we use an inner package to prevent the
    -- constructor from being inherited by further derivatives
    -- of Employee
    
    FUNCTION  MakeEmployee(Name     : String;    
                           Gender   : Genders; 
                           BirthDate: Date; 
                           StartDate: Date; 
                           ID       : IDType) RETURN Employee;
    -- Pre:  Name, Gender, BirthDate, StateDate, and ID are defined
    -- Post: Whom contains the desired field values                      

  END Constructors;

PRIVATE

  TYPE Employee IS NEW Person WITH RECORD
    ID        : IDType := 1111;
    StartDate : Date;
  END RECORD;

END Personnel;
