WITH Sets_Generic;
WITH Queues_Generic;
WITH Text_IO;
PACKAGE BODY Digraphs_Generic IS
------------------------------------------------------------------------
--| Body for unweighted digraphs with discrete vertex sets
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PACKAGE VertexSets IS NEW Sets_Generic(Universe => Vertices); 
  USE VertexSets;
  PACKAGE VertexQueues IS NEW Queues_Generic(Element => Vertices); 
  USE VertexQueues;

  -- constructors

  PROCEDURE InitializeGraph (G: IN OUT Digraph) IS
  BEGIN
    G.Store := (OTHERS => (OTHERS => False));
  END InitializeGraph;
  
  PROCEDURE AddEdge (G: IN OUT Digraph; Source, Destination: IN Vertices) IS
  BEGIN
    G.Store(Source, Destination) := True;
  END AddEdge;

  PROCEDURE DeleteEdge (G: IN OUT Digraph; Source, Destination: IN Vertices) IS
  BEGIN
    G.Store(Source, Destination) := False;
  END DeleteEdge;

  FUNCTION IsEmpty (G: Digraph) RETURN Boolean IS
  BEGIN
    FOR Row IN Vertices LOOP
      FOR Column IN Vertices LOOP
        IF G.Store(Row, Column) THEN
          RETURN False;
        END IF;
      END LOOP;
    END LOOP;
    RETURN True;
  END IsEmpty;
 
  FUNCTION NumberOfEdges (G: Digraph) RETURN Natural IS
    Total: Natural := 0;
  BEGIN
    FOR Row IN Vertices LOOP
      FOR Column IN Vertices LOOP
        IF G.Store(Row, Column) THEN
          Total := Total + 1;
        END IF;
      END LOOP;
    END LOOP;
    RETURN Total;
  END NumberOfEdges;
  
  FUNCTION IsAdjacent (G: Digraph; Source, Destination: Vertices) RETURN Boolean IS
  BEGIN
    RETURN G.Store(Source, Destination);
  END IsAdjacent;

  PROCEDURE DisplayGraph(G: Digraph) IS
  BEGIN
    FOR Row IN Vertices LOOP
      FOR Column IN Vertices LOOP
        IF G.Store(Row, Column) THEN
          Text_IO.Put (Item => "T ");
        ELSE
          Text_IO.Put (Item => "F ");
        END IF;
      END LOOP;
      Text_IO.New_Line;
    END LOOP;
  END DisplayGraph;

  PROCEDURE Traverse_BFS (G: IN Digraph; Start: Vertices) IS SEPARATE;
  
  PROCEDURE Traverse_DFS (G: IN Digraph; Start: Vertices) IS SEPARATE;
  
END Digraphs_Generic;
