WITH Ada.Text_IO;
PACKAGE BODY Debugging_Support IS
------------------------------------------------------------------------
--| Body of Package for Debugging Other Packages
--| WITH-ed by the body of a package to provide an easy way to
--| trace calls and returns from subprograms;
--| WITH-ed by a client of the package only to turn debugging on.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  DebuggingIsOn: Boolean := False;
  -- no debugging unless client calls SetDebug(WhichWay => On);

  DebugFile: Ada.Text_IO.File_Type;
  WritingToFile: Boolean := False;
  -- use standard output unless  client gives a file name

  PROCEDURE SetDebug(WhichWay: IN Switch; FileName: String := "") IS
  BEGIN -- SetDebug
    IF WhichWay = Off THEN
      DebuggingIsOn := False;
    ELSE
      DebuggingIsOn := True;

      -- Open debugging file, if any
      IF FileName /= "" THEN
        WritingToFile := True;
        Ada.Text_IO.Create(File => DebugFile, 
                           Mode => Ada.Text_IO.Out_File,
                           Name => FileName);
      END IF;
    END IF;
  END SetDebug;

  PROCEDURE Enter(Subprogram: IN String; Message: IN String := "") IS
  BEGIN -- Enter
    IF WritingToFile THEN
      Ada.Text_IO.Put
        (File => DebugFile, Item => ">>>>> Entering " & Subprogram);
      IF Message /= "" THEN
        Ada.Text_IO.Put(File => DebugFile, Item => "; " & Message);
      END IF;
      Ada.Text_IO.New_Line(File => DebugFile);
    ELSE -- standard output
      Ada.Text_IO.Put(Item => ">>>>> Entering " & Subprogram);
      IF Message /= "" THEN
        Ada.Text_IO.Put(Item => "; " & Message);
      END IF;
      Ada.Text_IO.New_Line;
    END IF;
  END Enter;

  PROCEDURE Leave(Subprogram: IN String; Message: IN String := "") IS
  BEGIN -- Leave
    IF WritingToFile THEN
      Ada.Text_IO.Put
        (File => DebugFile, Item => ">>>>> Leaving " & Subprogram);
      IF Message /= "" THEN
        Ada.Text_IO.Put(File => DebugFile, Item => "; " & Message);
      END IF;
      Ada.Text_IO.New_Line(File => DebugFile);
    ELSE -- standard output
      Ada.Text_IO.Put(Item => ">>>>> Leaving " & Subprogram);
      IF Message /= "" THEN
        Ada.Text_IO.Put(Item => "; " & Message);
      END IF;
      Ada.Text_IO.New_Line;
    END IF;
  END Leave;

END Debugging_Support;
