WITH Reporter; USE Reporter;
WITH Types; USE Types;
PACKAGE BODY Database IS
------------------------------------------------------------------------
--| Body of database package. The protected procedures ensure that
--| only one call at a time is exexuted.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  TYPE AccountRecord IS RECORD
    Valid: Boolean := False;
    Balance: Money := 0;
  END RECORD;

  TYPE AccountType IS ARRAY (CustID) OF AccountRecord;

  Next: CustID;
  Accounts: AccountType;

  PROTECTED BODY Manager IS

    PROCEDURE EnterCustID (ID : OUT CustID; Stat: OUT Status) IS
    BEGIN
      Next := Next + 1;
      ID := Next;
      Accounts(ID).Valid := True;
      Stat := OK;
    END EnterCustID;
  
    PROCEDURE Deposit (ID : CustID; Amount : IN Money;
                    NewBalance: OUT Money; Stat : OUT Status) IS
    BEGIN
      IF NOT Accounts(ID).Valid THEN
        Stat := BadCustID;
      ELSE
        Accounts(ID).Balance := Accounts(ID).Balance + Amount;
        NewBalance := Accounts(ID).Balance;
        Stat := OK;
      END IF;
    END Deposit;
  
    PROCEDURE Withdraw (ID : CustID; Amount : IN Money;
                    NewBalance: OUT Money; Stat : OUT Status) IS
    BEGIN
      IF NOT Accounts(ID).Valid THEN
        Stat := BadCustID;
      ELSIF Accounts(ID).Balance - Amount <= 0 THEN  
        Stat := InsufficientFunds;
      ELSE
        Accounts(ID).Balance := Accounts(ID).Balance + Amount;
        NewBalance := Accounts(ID).Balance;
        Stat := OK;
      END IF;
    END Withdraw;
  
    PROCEDURE Balance (ID : CustID; Amount : OUT Money; Stat: OUT Status) IS
    BEGIN
      IF NOT Accounts(ID).Valid THEN
        Stat := BadCustID;
      ELSE
        Amount := Accounts(ID).Balance;
        Stat := OK;
      END IF;
    END Balance;
  
  END Manager;
  
END Database;
