-----------------------------------------------------------------------
--
--  File:        pckeyboa.ads
--  Description: Basic keyboard interface
--  Rev:         0.7
--  Date:        01-feb-98
--  Author:      Jerry van Dijk
--  Mail:        jdijk@acm.org
--
--  Copyright (c) Jerry van Dijk, 1996, 1997, 1998
--  Billie Holidaystraat 28
--  2324 LK Leiden
--  THE NETHERLANDS
--  tel int + 31 71 531 4365
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------


   ------------------------------------------------------------
   --                       PACKAGE CONTAINS                 --
   ------------------------------------------------------------
   -- Types:                                                 --
   --    Keyboard_Scancode - Scancode of a keypress          --
   --                                                        --
   -- Functions:                                             --
   --    Is_Key_Waiting    - Check if a key has been pressed --
   --    Get_Scancode      - Waits for a key press           --
   --    Get_Char          - Waits for a key press           --
   ------------------------------------------------------------


package PC_Keyboard is

   -------------------------------------
   -- NAME:    Keyboard_Scancode      --
   --                                 --
   -- PURPOSE: Scancode of a keypress --
   -------------------------------------
   subtype Keyboard_Scancode is Integer range 0..2**16-1;


   ----------------------------------------------------
   -- NAME:    Is_Key_Waiting                        --
   --                                                --
   -- PURPOSE: Check if a key has been pressed       --
   --                                                --
   -- RETURNS: True if key pressed, False otherwise  --
   --                                                --
   -- NOTES:   1. Leaves keypress in keyboard buffer --
   ----------------------------------------------------
   function Is_Key_Waiting return Boolean;


   -------------------------------------------
   -- NAME:    Get_Scancode                 --
   --                                       --
   -- PURPOSE: Waits for a key press        --
   --                                       --
   -- RETURNS: Key Scancode                 --
   --                                       --
   -- NOTES:   1. Control-Break not noticed --
   -------------------------------------------
   function Get_Scancode return Keyboard_Scancode;


   --------------------------------------------------
   -- NAME:    Get_Char                            --
   --                                              --
   -- PURPOSE: Waits for a key press               --
   --                                              --
   -- RETURNS: Character pressed, NUL if not ASCII --
   --                                              --
   -- NOTES:   1. Control-Break not noticed        --
   --------------------------------------------------
   function Get_Char return Character;

end PC_Keyboard;
