
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adreedbo.adb "adatui-repaint_edit_box.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure repaint_edit_box (
   a_window : pdcurses.A_WINDOW_T;
   x        : integer;
   buffer   : string ) 
is
   temp_str   : bstrings.bounded_string;
   temp_charv : aliased c.charv(1..80); 
   temp_charp : c.charp;
   void       : c.signed_int;

begin
   void := pdcurses.werase ( a_window );
   temp_str := pad_string (
      str    => buffer,
      length => integer ( pdcurses.getmaxx(a_window) ) );

   make_charv (
      source => temp_str,
      target => temp_charv );
--
-- using unchecked access because type c.charp is defined at a higher
-- level than temp_charv - creates a potential for dangling pointers
--
   temp_charp := temp_charv'unchecked_access;

   void := pdcurses.mvwprintw ( a_window, 0, 0, temp_charp );
--
-- Using x-1 to put cursor in proper place - bounded_strings
-- used in field buffers begin at 1 not zero. 
--
   void := pdcurses.wmove     ( a_window, 0, c.signed_int(x-1) );
   void := pdcurses.wrefresh  ( a_window );
end repaint_edit_box;
