
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: admakcha.adb "adatui-make_charv.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure make_charv (
   source  : in     bstrings.bounded_string;
   target  :    out c.charv ) 
is
   count   : interfaces.c.size_t;

begin
   interfaces.c.to_c (
      item   => bstrings.to_string ( source ),
      target => target,
      count  => count );
end make_charv;
