
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adatui.ads 
--        Date: 12/24/95 
-- Description: Package specification for AdaTUI, the
--              Ada 95 version of the Textual User Interface 
--              (TUI) version 1.02 created by P. J. Kunst and 
--              included as sample C code with PDCurses 
--              version 2.2.  Implements a basic user 
--              interface that includes functions for pull-
--              down menus and input boxes.
--      Usages: Implemented as a parameter-less generic
--              package to work with Ada's pointer scoping
--              rules.  To use AdaTUI in an application, 
--              instantiate a version of this package in 
--              same scope where menu-driven procedures are
--              declared. 
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

with c;
with bstrings;
with pdcurses; 
with interfaces.c;
with system;

generic
package AdaTUI is

   A_ATTR    : constant := 8#31770000000#;     -- tui.h:40
   MAXSTRLEN : constant :=       16#0100#;     -- tui.h:46
   KEY_ESC   : constant :=       16#001B#;     -- tui.h:47
   KEY_LEFT  : constant :=       16#004B#;     -- AAD, 5/18/96
   KEY_RIGHT : constant :=       16#004D#;     -- AAD, 5/18/96
   KEY_DOWN  : constant :=       16#0050#;     -- AAD, 5/18/96
   KEY_UP    : constant :=       16#0048#;     -- AAD, 5/18/96
   KEY_IC    : constant :=       16#0052#;     -- AAD, 5/18/96
   KEY_DC    : constant :=       16#0053#;     -- AAD, 5/18/96
   PADENTER  : constant :=       16#00FD#;     -- AAD, 5/18/96
   NEWLINE   : constant :=             10;
   TAB       : constant :=              9;

   type A_FUNC is access procedure;            -- tui.h:49
   type a_string_t is access all string;

   type menu_item is                           -- tui.h:56
   record
      item_name: a_string_t;                   -- tui.h:53
      item_func: A_FUNC;                       -- tui.h:54
      item_desc: a_string_t;                   -- tui.h:55
   end record;

--
-- Changed menu type to a constrained array to keep GNAT 3.03 happy
-- when using pointers later.
-- AAD - 5/31/96
--
   LAST_ITEM : constant := 15;
   subtype menu_range is natural range 0..LAST_ITEM;
   type menu is 
      array ( 0..LAST_ITEM ) of menu_item;     -- tuidemo.c:143

   type a_menu_t is 
      access all menu;                         -- tui.h:78

--
-- for get_strings
--
   type input_field is
   record
      description : bstrings.bounded_string;
      buffer      : bstrings.bounded_string;
   end record;

   type input_items is
      array ( integer range <> ) of input_field;

--
-- AdaTUI Subprograms
--

   procedure clear_body_win;                   -- tui.h:60

   procedure refresh_body_win;

   function body_length return integer;        -- tui.h:61

   function body_win return pdcurses.A_WINDOW_T; -- tui.h:62

   procedure rmerror;                          -- tui.h:64

   procedure rmstatus;                         -- tui.h:65

   procedure title_message  ( msg : string );  -- tui.h:67

   procedure body_message   ( msg : string );  -- tui.h:68

   procedure error_message  ( msg : string );  -- tui.h:69

   procedure status_message ( msg : string );  -- tui.h:70

   function key_pressed return boolean;        -- tui.h:72

   function get_key return integer;            -- tui.h:73

   procedure flush_keys;                       -- tui.h:74

   function wait_for_key return integer;       -- tui.h:75

   procedure do_exit;                          -- tui.h:77

   procedure start_menu (
      mp    : a_menu_t;
      title : string  );                       -- tui.h:78

   procedure do_menu ( mp : a_menu_t );        -- tui.h:79

   procedure win_edit_string (
      window :        pdcurses.A_WINDOW_T;
      buffer : in out bstrings.bounded_string;
      field  : in     integer;
      key    :    out integer );               -- tui.h:81

   function win_input_box (
      a_window  : pdcurses.A_WINDOW_T;
      num_lines : integer;
      num_cols  : integer )
      return pdcurses.A_WINDOW_T;                -- tui.h:82

   procedure get_strings (
      items : in out input_items; 
      field : in     integer;
      key   :    out integer );                -- tui.h:83

--
-- The following are defined as macros in tui.h
--

   procedure edit_string ( 
      buffer : in out bstrings.bounded_string;
      field  : in     integer;
      key    :    out integer );               -- tui.h:81

   procedure move_edit_string (
      y      : in     integer;
      x      : in     integer;
      buffer : in out bstrings.bounded_string;
      field  : in     integer;
      key    :    out integer );               -- tui.h:82

   procedure move_win_edit_string (
      window :        pdcurses.A_WINDOW_T;
      y      : in     integer;
      x      : in     integer;
      buffer : in out bstrings.bounded_string;
      field  : in     integer;
      key    :    out integer );               -- tui.h:82

   function input_box ( 
      lines : integer;
      cols  : integer)
      return pdcurses.A_WINDOW_T;

   function move_input_box (
      y      : integer;
      x      : integer;
      lines  : integer;
      cols   : integer)
      return   pdcurses.A_WINDOW_T;

   function win_move_input_box (
      win   : pdcurses.A_WINDOW_T;
      y     : integer;
      x     : integer;
      lines : integer;
      cols  : integer)
      return  pdcurses.A_WINDOW_T;

--
-- Allows tuidemo.show_file to access body_window
--
   procedure body_window_addch ( item : character );

end AdaTUI;
