
with TEXT_IO;

package body easy_io is
  package INT_IO is new TEXT_IO.INTEGER_IO(integer);
  package FLT_IO is new TEXT_IO.FLOAT_IO(float);


procedure PUT(x: in CHARACTER) is
begin
   TEXT_IO.PUT(x);
end PUT;

procedure GET(x: out CHARACTER) is
begin
   TEXT_IO.GET(x);
end GET;

procedure GET_LINE(x: out CHARACTER) is
begin
   TEXT_IO.GET(x);
   TEXT_IO.NEW_LINE;
end GET_LINE;

procedure PUT_LINE(x: in CHARACTER) is
begin
   TEXT_IO.PUT(x);
   TEXT_IO.NEW_LINE;
end PUT_LINE;



procedure PUT(x: in INTEGER) is
begin
   INT_IO.PUT(x);
end PUT;

procedure GET(x: out INTEGER) is
begin
   INT_IO.GET(x);
end GET;

procedure GET_LINE(x: out INTEGER) is
begin
   INT_IO.GET(x);
   TEXT_IO.NEW_LINE;
end GET_LINE;

procedure PUT_LINE(x: in INTEGER) is
begin
   INT_IO.PUT(x);
   TEXT_IO.NEW_LINE;
end PUT_LINE;



procedure PUT(x: in FLOAT) is
begin
   FLT_IO.PUT(x);
end PUT;

procedure GET(x: out FLOAT) is
begin
   FLT_IO.GET(x);
end GET;

procedure GET_LINE(x: out FLOAT) is
begin
   FLT_IO.GET(x);
   TEXT_IO.NEW_LINE;
end GET_LINE;

procedure PUT_LINE(x: in FLOAT) is
begin
   FLT_IO.PUT(x);
   TEXT_IO.NEW_LINE;
end PUT_LINE;

procedure PUT_LINE(x: in FLOAT; width: in NATURAL; mantissa: in NATURAL) is
begin
   FLT_IO.PUT(x, Fore=>width, Aft=>mantissa, Exp=>0);
   TEXT_IO.NEW_LINE;
end PUT_LINE;


procedure GET(x: out STRING) is
begin
   TEXT_IO.GET(x);
end GET;

procedure PUT(x: in STRING) is
begin
   TEXT_IO.PUT(x);
end PUT;

procedure GET_LINE(x: out STRING; last: out NATURAL) is
begin
   TEXT_IO.GET_LINE(x, last);
end GET_LINE;

procedure PUT_LINE(x: in STRING) is
begin
   TEXT_IO.PUT_LINE(x);
end PUT_LINE;



procedure NEW_LINE is
begin
   TEXT_IO.NEW_LINE;
end NEW_LINE;

end Easy_IO;


