
with text_io;

package body DRGEN is

-- I/O RELATED FUNCTIONS

	package INT_IO is new TEXT_IO.INTEGER_IO(integer);
	package FLT_IO is new TEXT_IO.FLOAT_IO(float);

	procedure PUT(x: in CHARACTER) is
	begin
		TEXT_IO.PUT(x);
	end PUT;

	procedure GET(x: out CHARACTER) is
	begin
		TEXT_IO.GET(x);
	end GET;

	procedure GET_LINE(x: out CHARACTER) is
	begin
		TEXT_IO.GET(x);
		TEXT_IO.NEW_LINE;
	end GET_LINE;

	procedure PUT_LINE(x: in CHARACTER) is
	begin
		TEXT_IO.PUT(x);
		TEXT_IO.NEW_LINE;
	end PUT_LINE;

	procedure PUT(x: in INTEGER) is
	begin
		INT_IO.PUT(x);
	end PUT;

	procedure GET(x: out INTEGER) is
	begin
		INT_IO.GET(x);
	end GET;

	procedure GET_LINE(x: out INTEGER) is
	begin
		INT_IO.GET(x);
		TEXT_IO.NEW_LINE;
	end GET_LINE;

	procedure PUT_LINE(x: in INTEGER) is
	begin
		INT_IO.PUT(x);
		TEXT_IO.NEW_LINE;
	end PUT_LINE;

	procedure PUT(x: in FLOAT) is
	begin
		FLT_IO.PUT(x);
	end PUT;

	procedure GET(x: out FLOAT) is
	begin
		FLT_IO.GET(x);
	end GET;

	procedure GET_LINE(x: out FLOAT) is
	begin
		FLT_IO.GET(x);
		TEXT_IO.NEW_LINE;
	end GET_LINE;

	procedure PUT_LINE(x: in FLOAT) is
	begin
		FLT_IO.PUT(x);
		TEXT_IO.NEW_LINE;
	end PUT_LINE;

	procedure PUT_LINE(x: in FLOAT; width: in NATURAL;
		mantissa: in NATURAL) is
	begin
		FLT_IO.PUT(x, Fore=>width, Aft=>mantissa, Exp=>0);
		TEXT_IO.NEW_LINE;
	end PUT_LINE;

	procedure GET(x: out STRING) is
	begin
		TEXT_IO.GET(x);
	end GET;

	procedure PUT(x: in STRING) is
	begin
		TEXT_IO.PUT(x);
	end PUT;

	procedure GET_LINE(x: out STRING; last: out NATURAL) is
	begin
		TEXT_IO.GET_LINE(x, last);
	end GET_LINE;

	procedure PUT_LINE(x: in STRING) is
	begin
		TEXT_IO.PUT_LINE(x);
	end PUT_LINE;

	procedure NEW_LINE is
	begin
		TEXT_IO.NEW_LINE;
	end NEW_LINE;

-- PARSING RELATED FUNCTIONS

	function upcase (c : in character) return character is
	begin
		case c is
			when 'a' => return 'A';
			when 'b' => return 'B';
			when 'c' => return 'C';
			when 'd' => return 'D';
			when 'e' => return 'E';
			when 'f' => return 'F';
			when 'g' => return 'G';
			when 'h' => return 'H';
			when 'i' => return 'I';
			when 'j' => return 'J';
			when 'k' => return 'K';
			when 'l' => return 'L';
			when 'm' => return 'M';
			when 'n' => return 'N';
			when 'o' => return 'O';
			when 'p' => return 'P';
			when 'q' => return 'Q';
			when 'r' => return 'R';
			when 's' => return 'S';
			when 't' => return 'T';
			when 'u' => return 'U';
			when 'v' => return 'V';
			when 'w' => return 'W';
			when 'x' => return 'X';
			when 'y' => return 'Y';
			when 'z' => return 'Z';
			when others => return c;
		end case;
	end upcase;

	procedure parse (str: in string; size: in natural;
		TokenList: in out TokenArray; TokenCount : out Integer) is

		subtype numb is character range '0'..'9';
		subtype alpha is character range 'A'..'Z';
		char_cnt, start_ptr, token_cnt, I: natural;
		in_literal : boolean := FALSE;
	begin
		char_cnt := 0;    -- counter of characters
		start_ptr := 1;   -- tells where a substring begins.
		token_cnt := 0;   -- counts the number of substrings found.
				  -- index to the array TokenList

		for I in TokenList'range loop
			TokenList(I).size := 0; --initializes all sizes to zero
		end loop;

		--if item in string is NOT a WHITESPACE
		for I in 1..size loop    --increment character counter
			if in_literal then
				if str(I) = ASCII.QUOTATION then
					-- no nested quotes for now
					token_cnt := token_cnt + 1;
					TokenList(token_cnt).str(1..char_cnt+2)
						:= str(start_ptr..I);
					TokenList(token_cnt).size :=
						char_cnt+2;
					start_ptr := I+1;
					char_cnt := 0;
					in_literal := FALSE;
				else
					char_cnt := char_cnt + 1;
				end if;
			elsif (str(I) = ASCII.QUOTATION) and not in_literal then
				in_literal := TRUE;
				start_ptr := I;
			elsif (str(I) /= ' ')
				and (str(I) /= ASCII.HT)
				and (str(I) /= ',')
				and (str(I) /= ';')
				and (str(I) /= ')')
				and (str(I) /= '(') then
					char_cnt := char_cnt + 1;
			elsif (char_cnt > 0) then
				-- else if the character is a WHITESPACE and
                                   -- the character counter is greater than
                                   -- zero then a substring has been found
				token_cnt := token_cnt + 1;
				TokenList(token_cnt).str(1..char_cnt) :=
					str(start_ptr..I-1);
				TokenList(token_cnt).size := char_cnt;
				start_ptr := I+1;
				char_cnt := 0;
        		else       -- (char_cnt = 0)
				start_ptr := I+1; -- move marker to next item
			end if;
			-- gets last token (not followed by a non-character)
			if((I = size) and (char_cnt > 0)) then
				token_cnt := token_cnt + 1;
				TokenList(token_cnt).str(1..char_cnt) :=
					str(start_ptr..I);
				TokenList(token_cnt).size := char_cnt;
			end if;
		end loop;
		TokenCount := token_cnt;
		-- for I in 1..token_cnt loop
		-- 	put("Token ");
		-- 	put(i);
		-- 	put("->");
		-- 	put(TokenList(I).str(1..TokenList(I).size));
		-- 	put("<- with size ");
		-- 	put(TokenList(I).size);
		-- 	new_line;
		-- end loop;
	end parse;

	procedure uppercase(str: in out string; size: in natural) is
		I: positive;
	begin
		for I in 1..size loop
			str(I) := upcase(str(I));
		end loop;
	end uppercase;

	function number (C : in character) return integer is
		--this changes a character into an integer
	begin
		case C is
			when '0' =>	return 0;
			when '1' =>	return 1;
			when '2' =>	return 2;
			when '3' =>	return 3;
			when '4' =>	return 4;
			when '5' =>	return 5;
			when '6' =>	return 6;
			when '7' =>	return 7;
			when '8' =>	return 8;
			when '9' =>	return 9;
			when others =>	put("`");
					put(C);
					put_line("' is not a DIGIT");
					new_line;
					raise error_condition;
		end case;
	end number;

	-- converts a string to an integer
	function atoi(in_str: in string; size: in natural) return integer is
		result: integer := 0;
		weight: positive := 1;
		I, digit: natural;
		negative: Boolean := FALSE;
		strsize: integer;
		str: string(1..40);
	begin
		strsize := size;
		if(in_str(1) = '-') then        -- remove the -ve sign
			negative := TRUE;
			for I in 1..strsize loop
				if(I < strsize) then
					str(I) := in_str(I+1);
				end if;
			end loop;
			strsize := strsize-1;
		else
			for I in 1..strsize loop
				str(I) := in_str(I);
			end loop;
		end if;

		for I in reverse 1..strsize loop    -- calculate integral value
			digit := number(str(I));
			result := result + digit*weight;
			weight := weight*10;
		end loop;

		if(negative) then
			result := result*(-1);
		end if;

		return (result);
	end atoi;

	-- converts string to boolean
	function atob(str: in string; size: in natural) return boolean is
	begin
		if (str(1..size) = "TRUE") then
			return True;
		elsif (str(1..size) = "FALSE") then
			return False;
		else
			put(str(1..size));
			put_line(" is not a boolean");
			new_line;
			raise error_condition;
		end if;
	end atob;

	-- converts a string to a float
	function atof(in_str: in string; size: in natural) return float is
		result: float := 0.0;
		weight: float := 1.0;
		frac_part: float := 0.0;
		frac_weight: float := 0.1;
		I, digit: natural;
		negative: Boolean := FALSE;
		strsize, dot_ptr: integer;
		str: string(1..40);
	begin
		strsize := size;

		if(in_str(1) = '-') then        -- remove the -ve sign
			negative := TRUE;
			for I in 1..strsize loop
				if(I < strsize) then
					str(I) := in_str(I+1);
				end if;
			end loop;
			strsize := strsize-1;
		else
			for I in 1..strsize loop
				str(I) := in_str(I);
			end loop;
		end if;

		dot_ptr := strsize + 1; -- find location of `dot', if it exists
		for I in 1..strsize loop
			if str(I) = '.' then
				dot_ptr := I;
			end if;
		end loop;

		for I in reverse 1..dot_ptr-1 loop  -- calculate integral value
			digit := number(str(I));
			result := result + float(digit)*weight;
			weight := weight*10.0;
		end loop;

		for I in dot_ptr+1..strsize loop   -- calculate fractional part
			digit := number(str(I));
			frac_part := frac_part + float(digit)*frac_weight;
			frac_weight := frac_weight*0.1;
		end loop;

		result := result + frac_part;

		if (negative) then            -- attach -ve sign, if it existed
			result := result*(-1.0);
		end if;

		return (result);
	end atof;

	-- converts a string like  'X' to a character.
	-- Here X represents a character
	function atoc(in_str: in string; size: in natural) return character is
	begin
		return in_str(2);
	end atoc;

	function is_digit(C: in character) return boolean is
	begin
		case C is
			when '0'..'9' => return true;
			when others   => return false;
		end case;
	end is_digit;

	-- returns TRUE if in_str is valid to be an INTEGER
	-- returns FALSE otherwise
	function is_integer(in_str: in string; size: in natural)
							return boolean is
		I: integer;
	begin
		if (in_str(1) /= '-') and (not is_digit(in_str(1))) then
			return FALSE;
		end if;

		for I in 2..size loop
			if(not is_digit(in_str(I))) then
				return FALSE;
			end if;
		end loop;

		return TRUE;
	end is_integer;

	-- returns TRUE if in_str is valid to be a BOOLEAN
	-- returns FALSE otherwise
	function is_boolean(in_str: in string; size: in natural)
		return boolean is
	begin
		if ((in_str(1..size) = "TRUE") or
				(in_str(1..size) = "FALSE")) then
			return TRUE;
		else
			return FALSE;
		end if;
	end is_boolean;

	-- returns TRUE if in_str is valid to be a FLOAT
	-- returns FALSE otherwise
	function is_float(in_str: in string; size: in natural) return boolean is
		dot_ptr: integer;
		I: natural;
	begin
		dot_ptr := size + 1;    -- find location of 'dot', if it exists
		for I in 1..size loop
			if in_str(I) = '.' then
				dot_ptr := I;
			end if;
		end loop;

		if in_str(1) /= '-' and in_str(1) /= '.'  and
				(not is_digit(in_str(1))) then
			return FALSE;
		end if;

		if in_str(1) = '.' and dot_ptr /= 1 then
			return FALSE;
		end if;

		for I in 2..dot_ptr-1 loop
			if (not is_digit(in_str(I))) then
				return FALSE;
			end if;
		end loop;

		for I in dot_ptr+1..size loop
			if(not is_digit(in_str(I))) then
				return FALSE;
			end if;
		end loop;
      
		return TRUE;
	end is_float;

	-- returns TRUE if in_str is valid to be a CHARACTER
	-- returns FALSE otherwise
	function is_character(in_str: in string; size: in natural)
		return boolean is
	begin
		if size /= 3  then
			return FALSE;
		end if;

		if in_str(1) = ''' and in_str(3) = ''' then
			return TRUE;
		else
			return FALSE;
		end if;
	end is_character;


-- HISTORY RELATED FUNCTIONS

	procedure INIT_LIST(L1: in out HISTORY_LIST) is
	begin
		L1.head := new NODE;         -- get dummy node
		L1.head.next := NULL;
		L1.tail := L1.head;
	end INIT_LIST;

	procedure INSERT(L1: in out HISTORY_LIST;  istring: in STRING;
			size: in INTEGER) is
		temp: NODE_PTR;
	begin
		temp := new NODE;
		temp.next := NULL;
		temp.Operation(1..size) := istring(1..size);
		temp.size := size;

		L1.tail.next := temp;
		L1.tail := temp;
	end INSERT;

	procedure DISPLAY(L1: in  HISTORY_LIST) is
		walk: NODE_PTR;
	begin
		walk := L1.head.next;

		while (walk /= NULL) loop
			put("      ");
			put_line(walk.Operation(1..walk.size));
			walk := walk.next;
		end loop;
	end DISPLAY;

end DRGEN;
