-- This file contains the method definitions for an integer ring which
-- is implemented as an array.

-- Sasa Tomic  Sept. 95
-- Ver. 1.0

package body Demo4 is

    procedure Insert_An_Object(r: IN OUT Integer_Ring; myData: IN integer) is
    temp:link;
    begin
	if (r.theSize < r.maxSize) then
	begin
            temp := new RingData;
            temp.value := myData;
	    if (r.theSize = 0) then
		temp.prev := temp;
		temp.next := temp;
	    else
		temp.prev := r.current;
		temp.next := r.current.next;
		r.current.next.prev := temp;
		r.current.next := temp;
	    end if;
	    r.current := temp; 
	    r.theSize := r.theSize + 1;
	end;	-- if statement
	else	
	    easy_io.put_line("Sorry, the ring is full.");
	    raise ring_full;
	end if;
    exception
	when ring_full =>
	    raise ;		
    end Insert_An_Object;

    function Current_Object(r: IN Integer_Ring) return integer is
    begin
	if(r.theSize > 0) then
	    return r.current.value;
	else
            easy_io.put_line("Sorry, the ring is empty.");
	    raise ring_empty;
        end if;
    exception
	when ring_empty =>
	    raise ; 
    end Current_Object;

    procedure Change_Current_Object(r: IN OUT Integer_Ring; myData: IN integer) is
    begin
        if(r.theSize > 0) then
           r.current.value := myData;
        else
           easy_io.put_line("Sorry, the ring is empty.");
	   raise ring_empty;
        end if;
     exception
	when ring_empty =>
	    raise ;
     end Change_Current_Object; 	

    procedure Delete_Current_Object(r: IN OUT Integer_Ring) is
    temp: link;
    begin
        if(r.theSize > 0) then
	    temp := r.current;
	    if (r.theSize > 1) then
		r.current.next.prev := r.current.prev;
		r.current.prev.next := r.current.next;
		r.current := r.current.next;
	    else
		r.current := NULL;
	    end if;
	    r.theSize := r.theSize - 1;
	else
	    easy_io.put_line("Sorry, the ring is empty.");
	    raise ring_empty;
        end if;
     exception
        when ring_empty =>
            raise ;
    end Delete_Current_Object;

    function Number_Of_Objects(r: IN Integer_Ring) return integer is
    begin
	return r.theSize;
    end Number_Of_Objects;

    procedure  Move_Cursor_Forward(r: IN OUT Integer_Ring) is
    begin
        if(r.theSize > 0) then
	    r.current := r.current.next;
        else
            easy_io.put_line("Sorry, the ring is empty.");
	    raise ring_empty;
        end if;
     exception
        when ring_empty =>
            raise ;
    end Move_Cursor_Forward;

    procedure  Move_Cursor_Backward(r: IN OUT Integer_Ring) is
    begin
        if(r.theSize > 0) then
	    r.current := r.current.prev;
        else
            easy_io.put_line("Sorry, the ring is empty.");
            raise ring_empty;
        end if;
     exception
        when ring_empty =>
            raise ;
    end Move_Cursor_Backward;
end Demo4;
 
