   10REM ***************************************
   20REM * Xfer/BBC                            *
   30REM * BBC <-> PC Serial Transfer program  *
   40REM * BBC End (Slave)                     *
   50REM * (c) Mark de Weger, 1996             *
   60REM ***************************************
   70:
   80:
   90REM *****************
  100REM Main program
  110REM *****************
  120:
  130REM Initialisation
  140PROCreset
  150REM Clear serial port buffers
  160*FX 21,1
  170*FX 21,2
  180MODE 7
  190ON ERROR PROCfatal_error
  200PROCsetvars
  210PROCassemble
  220PROCinitconnection
  230PROCmain
  240END
  250:
  260REM Main procedure
  270DEF PROCmain
  280REM Switch RS423 Escape off
  290*FX 181,1
  300REM Switch RS423 Printer selection off
  310*FX 5,0
  320REM Switch RS423 Output off
  330*FX 3,0
  340REM Switch output to printer off
  350VDU 3
  360PROCsetvars
  370REPEAT
  380REM Switch RS423 Output off
  390*FX 3,0
  400PROCstatus("waiting for command","",0)
  410g$=GET$
  420IF (g$="*") OR (g$="S") OR (g$="R") THEN name$=FNread_string
  430IF g$="*" THEN PROCoscli(name$)
  440IF g$="S" THEN PROCsendfile(name$)
  450IF g$="R" THEN PROCreceivefile(name$)
  460IF g$="T" THEN PROCtermemu
  470REM C: command to send current directory name (before transfer of file)
  480IF g$="C" THEN PROCsenddir
  490UNTIL g$="Q" OR g$="E"
  500:
  510REM Quit
  520PROCreset
  530REM Clear RS423 input buffer
  540*FX 21,1
  550IF g$="Q" THEN PROCstatus("quitting XFER","",0) ELSE PROCstatus("error at PC; quitting XFER","",0)
  560END
  570:
  580:
  590REM ******************
  600REM Oscli command
  610REM ******************
  620:
  630REM Carry out * command
  640DEF PROCoscli(oscli$)
  650REM Switch output to printer on (*FX 3,3 doesn't work for *-commands)
  660VDU 2
  670REM Select RS423 for printer output
  680*FX 5,2
  690ON ERROR PROCallowed_error
  700OSCLI(oscli$)
  710ON ERROR PROCfatal_error
  720PRINT sync_text$
  730REM Switch output to printer off
  740VDU 3
  750REM Deselect RS423 for printer output
  760*FX 5,0
  770ENDPROC
  780:
  790:
  800REM ******************
  810REM Send files to PC
  820REM ******************
  830:
  840REM Send file
  850DEF PROCsendfile(f$)
  860ON ERROR PROCallowed_error:ENDPROC
  870fh%=OPENIN(f$)
  880ON ERROR PROCfatal_error
  890REM Print string to show OPENIN went well
  900*FX 3,3
  910PRINT sync_text$
  920*FX 3,0
  930IF fh%=0 THEN fs%=0 ELSE fs%=EXT#fh%
  940REM If file does not exist: send 0 to pc
  950IF fh%=0 THEN OSCLI("FX3,3"):PROCwrite_integer(fh%):OSCLI("FX3,0"):ENDPROC
  960PROCstatus("sending file",f$,fs%)
  970REM Select serial port for output
  980*FX 3,3
  990REM Send confirmation that file exists (by non-0 number)
 1000PROCwrite_integer(fh%)
 1010REM Send file size
 1020PROCwrite_integer(fs%)
 1030REM Send file contents
 1040crc2%=FNsfc(fh%,fs%)
 1050CLOSE#fh%
 1060REM Send CRC
 1070PROCwrite_integer(crc2%)
 1080REM Send .inf file
 1090PROCsendinf(f$,fs%)
 1100REM Select VDU for output
 1110*FX 3,0
 1120ENDPROC
 1130:
 1140REM Send file contents
 1150DEF FNsfc(fh%,fs%)
 1160REM Initialise
 1170!crc%=0
 1180?bufstart%=buffer% MOD 256
 1190bufstart%?1=buffer% DIV 256
 1200?pblockstart%=pblock% MOD 256
 1210pblockstart%?1=pblock% DIV 256
 1220?pblock%=fh%
 1230?blocks_tbt%=(fs% DIV bufsize%)+1
 1240rest_bytes%=fs% MOD bufsize%
 1250IF rest_bytes%=0 THEN rest_bytes%=bufsize%:?blocks_tbt%=?blocks_tbt%-1
 1260?end_lb%=(buffer%+rest_bytes%) MOD 256
 1270end_lb%?1=(buffer%+rest_bytes%) DIV 256
 1280?bufend%=(buffer%+bufsize%) MOD 256
 1290bufend%?1=(buffer%+bufsize%) DIV 256
 1300REM Do it
 1310CALL sendfile
 1320=!crc%
 1330:
 1340REM Send .inf file
 1350DEF PROCsendinf(f$,length%)
 1360REM Osfile 5: reads file's catalog info
 1370$nblock%=f$
 1380?pblock%=nblock% MOD 256
 1390pblock%?1=nblock% DIV 256
 1400X%=pblock% MOD 256
 1410Y%=pblock% DIV 256
 1420A%=5
 1430CALL osfile%
 1440start%=pblock%!2 AND &00FFFFFF
 1450exec%=pblock%!6 AND &00FFFFFF
 1460load%=pblock%!&0A AND &00FFFFFF
 1470IF pblock%!&0E <> 0 THEN locked$="Locked" ELSE locked$=""
 1480IF MID$(f$,2,1)="." THEN dir$="" ELSE dir$=FNgetcurrentdir+"."
 1490PRINT dir$;f$;"  ";~start%;"  ";~exec%;"  ";~length%;"  ";locked$
 1500ENDPROC
 1510:
 1520:
 1530REM **********************
 1540REM Receive files from PC
 1550REM **********************
 1560:
 1570REM Receive file
 1580DEF PROCreceivefile(f$)
 1590REM Receive file attributes+length
 1600start%=FNread_integer
 1610exec%=FNread_integer
 1620length%=FNread_integer
 1630locked$=FNread_string
 1640PROCstatus("receiving file",f$,length%)
 1650ON ERROR PROCallowed_error:ENDPROC
 1660fh%=OPENOUT(f$)
 1670ON ERROR PROCfatal_error
 1680REM Print string to show OPENOUT went well
 1690*FX 3,3
 1700PRINT sync_text$
 1710*FX 3,0
 1720REM Receive file contents
 1730crc2%=FNgetfilecontents(fh%,length%)
 1740CLOSE#fh%
 1750IF crc2%=-1 THEN ENDPROC
 1760crcrec%=FNread_integer
 1770REM Tell pc if crc error
 1780*FX 3,3
 1790IF crcrec%<>crc2% THEN PRINT err_txt2$:ENDPROC ELSE PRINT sync_text$
 1800*FX 3,0
 1810REM Osfile 1: set file attributes
 1820$nblock%=f$
 1830?pblock%=nblock% MOD 256
 1840pblock%?1=nblock% DIV 256
 1850pblock%!2=start%
 1860pblock%!6=exec%
 1870pblock%!&0A=length%
 1880pblock%!&0E=0
 1890X%=pblock% MOD 256
 1900Y%=pblock% DIV 256
 1910A%=1
 1920CALL osfile%
 1930IF MID$(locked$,1,1)="L" THEN OSCLI("ACCESS "+f$+" L")
 1940ENDPROC
 1950:
 1960REM Receive file contents
 1970DEF FNgetfilecontents(fh%,fs%)
 1980REM Initialise
 1990!bytes_transferred%=0
 2000!crc%=0
 2010!filelength%=fs%
 2020?max_bib_min1%=(bufsize%-1) MOD 256
 2030max_bib_min1%?1=(bufsize%-1) DIV 256
 2040?bufstart%=buffer% MOD 256
 2050bufstart%?1=buffer% DIV 256
 2060?pblockstart%=pblock% MOD 256
 2070pblockstart%?1=pblock% DIV 256
 2080?pblock%=fh%
 2090REM Do it
 2100ON ERROR PROCallowed_error:ENDPROC
 2110CALL receivefile
 2120ON ERROR PROCfatal_error
 2130=!crc%
 2140:
 2150:
 2160REM ****************************
 2170REM Terminal emulation
 2180REM ****************************
 2190:
 2200REM Start terminal emulation
 2210DEF PROCtermemu
 2220PROCstatus("terminal emulation","",0)
 2230REM Select RS423 as printer (*FX 3,3 doesn't work for *-commands)
 2240*FX 5,2
 2250REM Switch output to printer on
 2260VDU 2
 2270REM Enable RS423 Escape
 2280*FX 181,0
 2290END
 2300ENDPROC
 2310:
 2320:
 2330REM ****************************
 2340REM Send current directory name
 2350REM ****************************
 2360:
 2370DEF PROCsenddir
 2380dir$=FNgetcurrentdir
 2390REM Switch RS423 output on
 2400*FX3,3
 2410PRINT dir$
 2420REM Switch RS423 output off
 2430*FX3,0
 2440ENDPROC
 2450:
 2460:
 2470REM ****************************
 2480REM Initialisation/error/status
 2490REM ****************************
 2500:
 2510REM Initialise and check connection
 2520DEF PROCinitconnection
 2530PROCstatus("Waiting for connection","",0)
 2540REM 1200 Baud RS423 Receiving
 2550*FX 7,4
 2560REM Receive from RS423
 2570*FX 2,1
 2580REM Test connection
 2590text$=FNread_string
 2600IF text$<>sync_text$ THEN PROCreset:PRINT "Invalid data received. Please try again.":END
 2610REM Get baud rate and set it
 2620x%=FNread_integer
 2630PRINT
 2640PRINT "Initializing at ";STR$(x%);" baud."
 2650PRINT
 2660REM Osbyte 7: set RS423 receiving speed
 2670IF x%=1200 THEN X%=4
 2680IF x%=2400 THEN X%=5
 2690IF x%=4800 THEN X%=6
 2700IF x%=9600 THEN X%=7
 2710IF x%=19200 THEN X%=8
 2720A%=7
 2730CALL osbyte%
 2740REM Osbyte 8: set RS423 sending speed
 2750A%=8
 2760CALL osbyte%
 2770ENDPROC
 2780:
 2790REM Initialise variables
 2800DEF PROCsetvars
 2810DIM pblock% &11
 2820DIM nblock% &F
 2830osbyte%=&FFF4
 2840oscli%=&FFF7
 2850osfile%=&FFDD
 2860osgbpb%=&FFD1
 2870oswrch%=&FFEE
 2880sync_text$="-----BBC-----PC-----"
 2890err_txt$="-----BBCerror-----PC-----"
 2900err_txt2$="-----BBCerror-----PC-----2"
 2910@%=&90A
 2920REM Variables for mc
 2930bufsize%=4000
 2940bytes_in_buffer%=&70
 2950max_bib_min1%=&72
 2960crc%=&74
 2970filelength%=&78
 2980bytes_transferred%=&7C
 2990bufptr%=&80
 3000bufstart%=&82
 3010pblockstart%=&84
 3020end_lb%=&86
 3030bufend%=&88
 3040blocks_tbt%=&8A
 3050receivefile=M%
 3060sendfile=N%
 3070ENDPROC
 3080:
 3090REM Print status of connection
 3100DEF PROCstatus(status$,file$,length%)
 3110CLS
 3120PRINT CHR$141;"XFER/BBC"
 3130PRINT CHR$141;"XFER/BBC"
 3140PRINT
 3150PRINT "(c) 1996 Mark de Weger"
 3160PRINT
 3170PRINT
 3180PRINT ""
 3190PRINT "Status: ";status$
 3200IF file$<>"" THEN PRINT "  File name: ";file$
 3210IF length%<>0 THEN PRINT "  File length: ";STR$(length%)
 3220PRINT ""
 3230ENDPROC
 3240:
 3250REM Reset RS423
 3260DEF PROCreset
 3270ON ERROR OFF
 3280REM Close serial port and reselect keyboard input
 3290*FX 2,0
 3300REM Flush serial port input buffer
 3310*FX 21,1
 3320REM Reselect VDU output
 3330*FX 3,0
 3340REM Deselect RS423 as printer destination
 3350*FX 5,0
 3360REM Switch printer output off
 3370VDU 3
 3380REM Close remaining open files
 3390CLOSE#0
 3400PRINT ""
 3410ENDPROC
 3420:
 3430REM Fatal error
 3440DEF PROCfatal_error
 3450PROCreset
 3460REPORT
 3470PRINT " at line ";ERL
 3480END
 3490ENDPROC
 3500:
 3510:
 3520REM ********************
 3530REM RS423 Utilities
 3540REM ********************
 3550:
 3560REM Read string
 3570DEF FNread_string
 3580LOCAL string$,g$
 3590string$=""
 3600REPEAT
 3610g$=GET$
 3620IF g$<>CHR$(13) THEN string$=string$+g$
 3630UNTIL g$=CHR$(13)
 3640=string$
 3650:
 3660REM Read integer
 3670DEF FNread_integer
 3680LOCAL s$
 3690s$=FNread_string
 3700=VAL(s$)
 3710:
 3720REM Write integer
 3730DEF PROCwrite_integer(i%)
 3740LOCAL s$,loop%
 3750s$=STR$(i%)
 3760PRINT s$
 3770ENDPROC
 3780:
 3790:
 3800REM ********************
 3810REM Other utilities
 3820REM ********************
 3830:
 3840REM Get current directory name
 3850DEF FNgetcurrentdir
 3860REM Osgbpb 6: read directory (and device)
 3870$nblock%="xxxx"
 3880pblock%?1=nblock% MOD 256
 3890pblock%?2=nblock% DIV 256
 3900pblock%?3=0
 3910pblock%?4=0
 3920X%=pblock% MOD 256
 3930Y%=pblock% DIV 256
 3940A%=6
 3950CALL osgbpb%
 3960=CHR$(nblock%?3)
 3970:
 3980REM Error to be trapped
 3990DEF PROCallowed_error
 4000ON ERROR PROCfatal_error
 4010REM Close open files
 4020CLOSE#0
 4030REM Switch off RS423 output
 4040*FX 3,0
 4050REM De-select RS423 printer
 4060*FX 5,0
 4070REM Switch output to printer off
 4080VDU 3
 4090REM Switch RS423 Escape off
 4100*FX 181,1
 4110PROCstatus("error, waiting for PC to respond","",0)
 4120REM Switch on RS423 output
 4130*FX 3,3
 4140REM Print string to tell PC of error
 4150PRINT err_txt$
 4160REM Wait for pc to respond acknowledgement of error
 4170pc$=""
 4180REPEAT
 4190g$=GET$
 4200IF g$<>"" THEN pc$=pc$+g$ ELSE pc$=""
 4210IF LEN(pc$)>LEN(err_txt$) THEN pc$=RIGHT$(pc$,LEN(pc$)-1)
 4220UNTIL pc$=err_txt$
 4230REM Send error to PC
 4240REPORT
 4250PRINT
 4260REM Switch off RS423 output
 4270*FX 3,0
 4280PROCmain
 4290:
 4300:
 4310REM ***********************
 4320REM Machine code generation
 4330REM ***********************
 4340:
 4350DEF PROCassemble
 4360DIM mc% 400
 4370DIM buffer% bufsize%
 4380FOR opt%=0 TO 3 STEP 3
 4390P%=mc%
 4400[
 4410OPT opt%
 4420\
 4430\ Receive file
 4440.receivefile
 4450.M%
 4460\ *bytes_in_buffer%=0
 4470LDA #0
 4480STA bytes_in_buffer%
 4490STA bytes_in_buffer%+1
 4500.fillrbloop
 4510\ if !bytes_transferred%=!filelength% then goto recexit
 4520LDA bytes_transferred%
 4530CMP filelength%
 4540BNE elsec
 4550LDA bytes_transferred%+1
 4560CMP filelength%+1
 4570BNE elsec
 4580LDA bytes_transferred%+2
 4590CMP filelength%+2
 4600BNE elsec
 4610LDA bytes_transferred%+3
 4620CMP filelength%+3
 4630BNE elsec
 4640JMP recexit
 4650.elsec
 4660\ if *bytes_in_buffer%=*max_bib_min1% then goto saveexit
 4670LDA bytes_in_buffer%
 4680CMP max_bib_min1%
 4690BNE getbyte
 4700LDA bytes_in_buffer%+1
 4710CMP max_bib_min1%+1
 4720BNE getbyte
 4730JMP saveexit
 4740.getbyte
 4750\ Y%=get from RS423 input buffer
 4760LDA #145
 4770LDX #1
 4780JSR osbyte%
 4790\ if not gotten then goto getbyte
 4800BCS getbyte
 4810\ *bufptr%=buffer%+*bytes_in_buffer%
 4820CLC
 4830LDA bufstart%
 4840ADC bytes_in_buffer%
 4850STA bufptr%
 4860LDA bufstart%+1
 4870ADC bytes_in_buffer%+1
 4880STA bufptr%+1
 4890\ ?(bufptr)=Y%
 4900TYA
 4910LDX #0
 4920STA (bufptr%,X)
 4930\ !crc%=!crc%+(bufptr%)
 4940CLC
 4950ADC crc%
 4960STA crc%
 4970BCC elsee
 4980LDA #0
 4990ADC crc%+1
 5000STA crc%+1
 5010BCC elsee
 5020LDA #0
 5030ADC crc%+2
 5040STA crc%+2
 5050BCC elsee
 5060LDA #0
 5070ADC crc%+3
 5080STA crc%+3
 5090.elsee
 5100\ !bytes_transferred%=!bytes_transferred%+1
 5110CLC
 5120LDA #1
 5130ADC bytes_transferred%
 5140STA bytes_transferred%
 5150BCC elsed
 5160LDA #0
 5170ADC bytes_transferred%+1
 5180STA bytes_transferred%+1
 5190BCC elsed
 5200LDA #0
 5210ADC bytes_transferred%+2
 5220STA bytes_transferred%+2
 5230BCC elsed
 5240LDA #0
 5250ADC bytes_transferred%+3
 5260STA bytes_transferred%+3
 5270.elsed
 5280\ *bytes_in_buffer%=*bytes_in_buffer%+1
 5290CLC
 5300LDA #1
 5310ADC bytes_in_buffer%
 5320STA bytes_in_buffer%
 5330LDA #0
 5340ADC bytes_in_buffer%+1
 5350STA bytes_in_buffer%+1
 5360\ goto fillrbloop
 5370JMP fillrbloop
 5380.saveexit
 5390JSR buffertofile
 5400JMP receivefile
 5410.recexit
 5420JSR buffertofile
 5430.rrecexit
 5440RTS
 5450\
 5460\ Save contents of buffer to file
 5470.buffertofile
 5480\ pblock%!1=*bufstart%
 5490LDY #1
 5500LDA bufstart%
 5510STA (pblockstart%),Y
 5520INY
 5530LDA bufstart%+1
 5540STA (pblockstart%),Y
 5550INY
 5560LDA #0
 5570STA (pblockstart%),Y
 5580INY
 5590STA (pblockstart%),Y
 5600\ pblock%!5=*bytes_in_buffer%
 5610INY
 5620LDA bytes_in_buffer%
 5630STA (pblockstart%),Y
 5640INY
 5650LDA bytes_in_buffer%+1
 5660STA (pblockstart%),Y
 5670INY
 5680LDA #0
 5690STA (pblockstart%),Y
 5700INY
 5710STA (pblockstart%),Y
 5720\ osgbpb 2 (Save block of data)
 5730LDA #2
 5740LDX pblockstart%
 5750LDY pblockstart%+1
 5760JSR osgbpb%
 5770RTS
 5780\
 5790\ Send file
 5800.sendfile
 5810.N%
 5820\ IF ?blocks_tbt%=0 THEN GOTO .sendexit
 5830LDA blocks_tbt%
 5840CMP #0
 5850BEQ sendexit
 5860\ load block of data
 5870\ pblock%!1=*bufstart%
 5880LDY #1
 5890LDA bufstart%
 5900STA (pblockstart%),Y
 5910INY
 5920LDA bufstart%+1
 5930STA (pblockstart%),Y
 5940INY
 5950LDA #0
 5960STA (pblockstart%),Y
 5970INY
 5980STA (pblockstart%),Y
 5990\ pblock%!5=bufsize%
 6000INY
 6010LDA #bufsize% MOD 256
 6020STA (pblockstart%),Y
 6030INY
 6040LDA #bufsize% DIV 256
 6050STA (pblockstart%),Y
 6060INY
 6070LDA #0
 6080STA (pblockstart%),Y
 6090INY
 6100STA (pblockstart%),Y
 6110\ load block
 6120LDA #4
 6130LDX pblockstart%
 6140LDY pblockstart%+1
 6150JSR osgbpb%
 6160\ ?blocks_tbt%=?blocks_tbt%-1
 6170DEC blocks_tbt%
 6180\ send block to pc and start new block
 6190JSR sendblock
 6200JMP sendfile
 6210.sendexit
 6220RTS
 6230\
 6240\ send block to pc and calculate crc
 6250.sendblock
 6260\ *bufptr%=*bufstart%
 6270LDA bufstart%
 6280STA bufptr%
 6290LDA bufstart%+1
 6300STA bufptr%+1
 6310.sbloop
 6320\ VDU ?(bufptr%)
 6330LDY #0
 6340LDA (bufptr%),Y
 6350JSR oswrch%
 6360\ !crc%=!crc%+?tempadr%
 6370CLC
 6380ADC crc%
 6390STA crc%
 6400BCC elses
 6410LDA #0
 6420ADC crc%+1
 6430STA crc%+1
 6440BCC elses
 6450LDA #0
 6460ADC crc%+2
 6470STA crc%+2
 6480BCC elses
 6490LDA #0
 6500ADC crc%+3
 6510STA crc%+3
 6520.elses
 6530\ *bufptr%=*bufptr%+1
 6540CLC
 6550LDA #1
 6560ADC bufptr%
 6570STA bufptr%
 6580LDA #0
 6590ADC bufptr%+1
 6600STA bufptr%+1
 6610\ IF ?blocks_tbt%<>0 THEN GOTO .testall
 6620LDA blocks_tbt%
 6630CMP #0
 6640BNE testall
 6650\ IF *bufptr%=*end_lb% THEN RETURN ELSE GOTO sbloop
 6660LDA bufptr%
 6670CMP end_lb%
 6680BNE elses1
 6690LDA bufptr%+1
 6700CMP end_lb%+1
 6710BNE elses1
 6720RTS
 6730.elses1
 6740JMP sbloop
 6750.testall
 6760\ IF *bufptr%=*bufend% THEN RETURN ELSE GOTO sbloop
 6770LDA bufptr%
 6780CMP bufend%
 6790BNE elses2
 6800LDA bufptr%+1
 6810CMP bufend%+1
 6820BNE elses2
 6830RTS
 6840.elses2
 6850JMP sbloop
 6860]
 6870NEXT
 6880ENDPROC