/* (bbcim) tst.c
 * Test for libbbcim
 *
 * Copyright (c) 1997 W.H. Scholten
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mytypes.h"
#include <bbcimlib.h>


int main() {
    struct diskimage image;
    struct bbcfile file;
    int  i, crc;

    printf("libbbcim test\n");

    image.type=DFS_DISK; image.sides=1;
    image.filename="t.1";
/*     disk_cat_extract_crc(&image, 0, NULL, &file, SHOW_FILES | VERBOSE); */
    disk_cat_extract_crc(&image, 0, NULL, &file, NEW_DISK);
    disk_cat_extract_crc(&image, 0, NULL, &file, GET_ATTRIBUTES);
    printf("Attributes\n");
    printf(" file %s, %d bytes\n", file.naam, file.length);
    printf(" load=%6x exec =%6x\n", file.loadaddr, file.execaddr);

    file.data=(byte *) malloc(file.length+1);
    disk_cat_extract_crc(&image, 0, NULL, &file, LOAD_FILE);
    printf("Loaded file %s, %d bytes\n", file.naam, file.length);
    printf(" load=%6x exec =%6x\n", file.loadaddr, file.execaddr);

    /* Proof: calc crc from data */
    crc=0;

    for (i=0; i<file.length; i++) {
	int k;
	int filebyte=file.data[i];

	crc ^=(filebyte << 8);
	for(k=0;k<8;k++) {
	    if (crc & 32768)
		crc =(((crc ^ 0x0810) & 32767) << 1)+1;
	    else
		crc =crc <<1;
	}
    }

    printf("crc from data is %x\n", crc);
    free(file.data);
    return 0;
}
