/* splits_cat.c
 *
 * Copyright (c) W.H.Scholten 1996, 1997
 * (bbcim)
 */

int  split_cat(char *cat_naam, int flags) {
    FILE *fpcat, *fpinfo;
    char infofile[100];
    char read_line[100], bbcfile_naam[15];
    char nieuwe_naam[100];
    int i, args;

    int antwoord;
int verbose;
    unsigned long load, exec, crc;

verbose=flags & VERBOSE;

    if (file_sanitycheck(cat_naam, verbose)) return -1;

    fpcat=fopen(cat_naam,"r");
    while (fscanf(fpcat,"%12s", bbcfile_naam)!=EOF) {
	bbcfile_naam[9]=0;
	fgets(read_line, 99, fpcat); /* GET REMAINDER OF LINE */
	if (bbcfile_naam[1]=='.') {
	    replace_bad_chars(bbcfile_naam);

	    if (!(flags & BBC_DIR))
		reduceer_unix_naam(infofile, bbcfile_naam);
	    else
		strcpy(infofile,bbcfile_naam);
	    strcat(infofile,".inf");

	    /* Check if file exists (can be opened) */
	    if ((fpinfo=fopen(infofile, "r"))!=NULL) {
		fclose(fpinfo);
		antwoord=overschrijf_vraag(bbcfile_naam, infofile);

		switch(antwoord) {
		case OVERSCHRIJVEN:
		    break;

		case HERNOEM_NIEUW:
		    strcpy(infofile, nieuwe_naam); break;

		case HERNOEM_BESTAAND:
		    rename(infofile, nieuwe_naam); break;

		case SLA_OVER:
		    continue; /*next in while loop*/
		} /* switch */
	    }
	    /* END NAME CHECK */

	    fpinfo=fopen(infofile, "w");
	    fprintf(fpinfo, bbcfile_naam);

	    for (i=0; i<99; i++) {
		if (read_line[i]>' ') break;
	    }

	    args =sscanf(read_line,"%*[ L\x09]%lx %lx %*[^=]=%x", &load, &exec, (uint *) &crc);
	    fprintf(fpinfo, "  %6lX  %6lX", load, exec);
	    if (read_line[i]=='L') fprintf(fpinfo, " Locked");
	    if (args==3) fprintf(fpinfo, "  CRC=%4X", (uint) crc);
	    fclose(fpinfo);
	}
    
    }
    fclose(fpcat);
    return 0;
}
