/* (bbcim) nieuw_diskb.c
 *
 * Copyright (c) 1996 W.H. Scholten
 */


/* Acorn DFS */
int  disk_new(struct diskimage *image, unsigned int size, int verbose) {
    FILE *fpdisk;
    unsigned char filebyte;
    long i;
    char *disk;


    disk=image->filename;
    bbcim_errno=0;
    fpdisk=fopen(disk,"wb");

    switch(image->type) {
    case DFS_DISK:
	filebyte=0;
	for (i=0; i<512; i++)
	    fwrite(&filebyte,1,1,fpdisk);

	size &=0xFFF; /* not allowed in true DFS but might be useful for big disks in beebem. */
	/* SET DISK SIZE & DEFAULT BOOT OPTION */
	filebyte=(size>>8);
	fseek(fpdisk,256+6L,SEEK_SET);
	filebyte |=3<<4;
	fwrite(&filebyte,1,1,fpdisk);  /*i.e. bootoption=*EXEC, sect on disk='size' */
	filebyte=(size & 0xFF);
	fwrite(&filebyte,1,1,fpdisk);
	break;
    case ADFS_DISK:
printf("create adfs disk\n");
    default:
	bbcim_errno=BBC_NOT_IMPLEMENTED;
    }

    if (bbcim_errno==BBC_NOT_IMPLEMENTED) {
printf("create disk err\n");
#ifdef NL
	bbcim_error="Niet geimplementeerd\n";
#else
	bbcim_error="Not implemented\n";
#endif
    }
    if (verbose) fprintf(stderr, bbcim_error);
    return bbcim_errno;
}
